/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import java.nio.file.Path;
import org.ballerinalang.langserver.extensions.ballerina.document.ExecutorPositionsUtil;

public class TestCaseVisitor
extends NodeVisitor {
    private final JsonArray execPositions;
    private final Path filePath;

    TestCaseVisitor(JsonArray execPositions, Path filePath) {
        this.execPositions = execPositions;
        this.filePath = filePath;
    }

    public void visitTestCases(Node node) {
        this.visitSyntaxNode(node);
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        if (functionDefinitionNode.metadata().isPresent()) {
            ((MetadataNode)functionDefinitionNode.metadata().get()).annotations().stream().filter(annotationNode -> annotationNode.annotReference().toString().trim().equals("test:Config")).toList().forEach(annotationNode -> {
                JsonObject testCase = new JsonObject();
                testCase.addProperty("kind", "test");
                testCase.addProperty("name", functionDefinitionNode.functionName().text());
                testCase.add("range", ExecutorPositionsUtil.GSON.toJsonTree((Object)functionDefinitionNode.location().lineRange()));
                testCase.addProperty("filePath", this.filePath.toString());
                this.execPositions.add((JsonElement)testCase);
            });
        }
    }
}

