/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.packages;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.projects.ConfigReader;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.configschema.ConfigSchemaBuilder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.langserver.extensions.ballerina.packages.DocumentComponentTransformer;
import org.ballerinalang.langserver.extensions.ballerina.packages.ModuleObject;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageComponentsRequest;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageComponentsResponse;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageConfigSchemaRequest;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageConfigSchemaResponse;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageContext;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageMetadataRequest;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageMetadataResponse;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageObject;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="ballerinaPackage")
public class BallerinaPackageService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;
    private LSClientLogger clientLogger;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager, LanguageServerContext serverContext) {
        this.workspaceManager = workspaceManager;
        this.clientLogger = LSClientLogger.getInstance(serverContext);
    }

    @JsonRequest
    public CompletableFuture<PackageMetadataResponse> metadata(PackageMetadataRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            PackageMetadataResponse metadata = new PackageMetadataResponse();
            try {
                Optional<Path> filePath = PathUtil.getPathFromURI(request.getDocumentIdentifier().getUri());
                if (filePath.isEmpty()) {
                    return metadata;
                }
                Optional project = this.workspaceManager.project(filePath.get());
                if (project.isEmpty()) {
                    return metadata;
                }
                metadata.setOrgName(((Project)project.get()).currentPackage().packageOrg().value());
                metadata.setPath(((Project)project.get()).sourceRoot().toString());
                ProjectKind projectKind = ((Project)project.get()).kind();
                if (projectKind != ProjectKind.SINGLE_FILE_PROJECT) {
                    metadata.setPackageName(((Project)project.get()).currentPackage().packageName().value());
                }
                metadata.setKind(projectKind.name());
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaPackage/metadata' failed!";
                this.clientLogger.logError(PackageContext.PACKAGE_METADATA, msg, e, request.getDocumentIdentifier(), new Position[]{null});
            }
            return metadata;
        });
    }

    @JsonRequest
    public CompletableFuture<PackageComponentsResponse> components(PackageComponentsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            PackageComponentsResponse response = new PackageComponentsResponse();
            JsonArray jsonPackages = new JsonArray();
            TextDocumentIdentifier[] documentIdentifiers = request.getDocumentIdentifiers();
            try {
                Arrays.stream(documentIdentifiers).iterator().forEachRemaining(documentIdentifier -> PathUtil.getPathFromURI(documentIdentifier.getUri()).ifPresent(path -> {
                    Project project = null;
                    try {
                        project = this.workspaceManager.loadProject(path);
                        jsonPackages.add((JsonElement)this.getPackageComponents(project));
                    }
                    catch (Throwable e) {
                        String msg = "Operation 'ballerinaPackage/components' load project failed!";
                        this.clientLogger.logError(PackageContext.PACKAGE_COMPONENTS, msg, e, null, new Position[0]);
                    }
                }));
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaPackage/components' failed!";
                this.clientLogger.logError(PackageContext.PACKAGE_COMPONENTS, msg, e, null, new Position[]{null});
            }
            response.setProjectPackages(jsonPackages);
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<PackageConfigSchemaResponse> configSchema(PackageConfigSchemaRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            PackageConfigSchemaResponse response = new PackageConfigSchemaResponse();
            try {
                Optional<Path> filePath = PathUtil.getPathFromURI(request.getDocumentIdentifier().getUri());
                if (filePath.isEmpty()) {
                    throw new UserErrorException("File path not found.");
                }
                Optional project = this.workspaceManager.project(filePath.get());
                if (project.isEmpty()) {
                    throw new UserErrorException("Project not found.");
                }
                this.workspaceManager.waitAndGetPackageCompilation(filePath.get()).ifPresent(compilation -> {
                    Package currentPackage = ((Project)project.get()).currentPackage();
                    response.setConfigSchema(new ConfigSchemaBuilder().getConfigSchemaContent(ConfigReader.getConfigVariables((Package)currentPackage)));
                });
            }
            catch (Exception e) {
                String msg = "Operation 'ballerinaPackage/configSchema' failed!";
                this.clientLogger.logError(PackageContext.PACKAGE_CONFIG_SCHEMA, msg, e, request.getDocumentIdentifier(), new Position[]{null});
            }
            return response;
        });
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    public JsonObject getPackageComponents(Project project) {
        Package currentPackage = project.currentPackage();
        PackageObject packageObject = new PackageObject(currentPackage.packageName().value(), project.sourceRoot().toUri().toString());
        currentPackage.moduleIds().forEach(moduleId -> {
            ModuleObject moduleObject = new ModuleObject();
            Module module = project.currentPackage().module(moduleId);
            SemanticModel semanticModel = currentPackage.getCompilation().getSemanticModel(moduleId);
            if (module.moduleName().moduleNamePart() != null) {
                moduleObject.setName(module.moduleName().moduleNamePart());
            }
            module.documentIds().forEach(documentId -> new DocumentComponentTransformer(moduleObject, semanticModel).getModuleObject(module.document(documentId).syntaxTree().rootNode()));
            packageObject.addModule(moduleObject);
        });
        return new Gson().toJsonTree((Object)packageObject).getAsJsonObject();
    }
}

