/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.symbol;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.diagramutil.connector.models.connector.Type;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.codeaction.MatchedExpressionNodeResolver;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManagerProxy;
import org.ballerinalang.langserver.contexts.ContextBuilder;
import org.ballerinalang.langserver.extensions.ballerina.symbol.BallerinaEndpointsResponse;
import org.ballerinalang.langserver.extensions.ballerina.symbol.Endpoint;
import org.ballerinalang.langserver.extensions.ballerina.symbol.ExpressionTypeRequest;
import org.ballerinalang.langserver.extensions.ballerina.symbol.ExpressionTypeResponse;
import org.ballerinalang.langserver.extensions.ballerina.symbol.ResolvedTypeForExpression;
import org.ballerinalang.langserver.extensions.ballerina.symbol.ResolvedTypeForSymbol;
import org.ballerinalang.langserver.extensions.ballerina.symbol.SymbolContext;
import org.ballerinalang.langserver.extensions.ballerina.symbol.SymbolDocumentation;
import org.ballerinalang.langserver.extensions.ballerina.symbol.SymbolInfoRequest;
import org.ballerinalang.langserver.extensions.ballerina.symbol.SymbolInfoResponse;
import org.ballerinalang.langserver.extensions.ballerina.symbol.TypeFromExpressionRequest;
import org.ballerinalang.langserver.extensions.ballerina.symbol.TypeFromSymbolRequest;
import org.ballerinalang.langserver.extensions.ballerina.symbol.TypesFromExpressionResponse;
import org.ballerinalang.langserver.extensions.ballerina.symbol.TypesFromFnDefinitionRequest;
import org.ballerinalang.langserver.extensions.ballerina.symbol.TypesFromSymbolResponse;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="ballerinaSymbol")
public class BallerinaSymbolService
implements ExtendedLanguageServerService {
    private WorkspaceManagerProxy workspaceManagerProxy;
    private LSClientLogger clientLogger;
    private LanguageServerContext serverContext;

    public void init(LanguageServer langServer, WorkspaceManagerProxy workspaceManagerProxy, LanguageServerContext serverContext) {
        this.workspaceManagerProxy = workspaceManagerProxy;
        this.serverContext = serverContext;
        this.clientLogger = LSClientLogger.getInstance(serverContext);
    }

    @JsonRequest
    public CompletableFuture<BallerinaEndpointsResponse> endpoints() {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaEndpointsResponse response = new BallerinaEndpointsResponse();
            response.setEndpoints(this.getClientEndpoints());
            return response;
        });
    }

    private List<Endpoint> getClientEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        return endpoints;
    }

    @JsonRequest
    public CompletableFuture<ExpressionTypeResponse> type(ExpressionTypeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ExpressionTypeResponse expressionTypeResponse = new ExpressionTypeResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
            if (filePath.isEmpty()) {
                return expressionTypeResponse;
            }
            try {
                expressionTypeResponse.setDocumentIdentifier(new TextDocumentIdentifier(fileUri));
                Optional semanticModel = this.workspaceManagerProxy.get().semanticModel(filePath.get());
                if (semanticModel.isEmpty()) {
                    return expressionTypeResponse;
                }
                Optional symbol = Optional.empty();
                for (int i = 0; i < request.getPosition().offset() && !(symbol = ((SemanticModel)semanticModel.get()).symbol((Document)this.workspaceManagerProxy.get().document(filePath.get()).get(), LinePosition.from((int)request.getPosition().line(), (int)(request.getPosition().offset() - i)))).isPresent(); ++i) {
                }
                symbol.ifPresent(value -> expressionTypeResponse.setTypes(this.getAllUnionTypes((Symbol)value)));
                return expressionTypeResponse;
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaSymbol/type' failed!";
                this.clientLogger.logError(SymbolContext.SC_TYPE_API, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return expressionTypeResponse;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<TypesFromExpressionResponse> getTypeFromExpression(TypeFromExpressionRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypesFromExpressionResponse typesResponse = new TypesFromExpressionResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            String[] pathSegments = fileUri.split("/");
            String fileName = pathSegments[pathSegments.length - 1];
            ArrayList<ResolvedTypeForExpression> types = new ArrayList<ResolvedTypeForExpression>();
            try {
                Path filePath = PathUtil.getPathFromURI(fileUri).orElseThrow();
                for (LineRange range : request.getExpressionRanges()) {
                    LinePosition end;
                    LinePosition start;
                    LineRange lineRange;
                    ResolvedTypeForExpression resolvedType = new ResolvedTypeForExpression(range);
                    SemanticModel semanticModel = (SemanticModel)this.workspaceManagerProxy.get(fileUri).semanticModel(filePath).orElseThrow();
                    if (!semanticModel.typeOf(lineRange = LineRange.from((String)fileName, (LinePosition)(start = range.startLine()), (LinePosition)(end = range.endLine()))).isPresent()) continue;
                    Optional typeSymbol = semanticModel.typeOf(lineRange);
                    Type type = typeSymbol.map(Type::fromSemanticSymbol).orElse(null);
                    Type.clearParentSymbols();
                    resolvedType.setType(type);
                    types.add(resolvedType);
                }
                typesResponse.setTypes(types);
                return typesResponse;
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaSymbol/getTypeFromExpression' failed!";
                this.clientLogger.logError(SymbolContext.SC_GET_TYPE_FROM_EXPRESSION_API, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return typesResponse;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<TypesFromSymbolResponse> getTypeFromSymbol(TypeFromSymbolRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypesFromSymbolResponse typeFromSymbolResponse = new TypesFromSymbolResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            ArrayList<ResolvedTypeForSymbol> types = new ArrayList<ResolvedTypeForSymbol>();
            try {
                Path filePath = PathUtil.getPathFromURI(fileUri).orElseThrow();
                for (LinePosition position : request.getPositions()) {
                    ResolvedTypeForSymbol resolvedType = new ResolvedTypeForSymbol(position);
                    SemanticModel semanticModel = (SemanticModel)this.workspaceManagerProxy.get(fileUri).semanticModel(filePath).orElseThrow();
                    Document document = (Document)this.workspaceManagerProxy.get(fileUri).document(filePath).orElseThrow();
                    LinePosition linePosition = LinePosition.from((int)position.line(), (int)position.offset());
                    Optional symbol = semanticModel.symbol(document, linePosition);
                    Type type = symbol.map(Type::fromSemanticSymbol).orElse(null);
                    Type.clearParentSymbols();
                    resolvedType.setType(type);
                    types.add(resolvedType);
                }
                typeFromSymbolResponse.setTypes(types);
                return typeFromSymbolResponse;
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaSymbol/getTypeFromSymbol' failed!";
                this.clientLogger.logError(SymbolContext.SC_GET_TYPE_FROM_SYMBOL_API, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return typeFromSymbolResponse;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<TypesFromSymbolResponse> getTypesFromFnDefinition(TypesFromFnDefinitionRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            TypesFromSymbolResponse typeFromSymbolResponse = new TypesFromSymbolResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            ArrayList<ResolvedTypeForSymbol> types = new ArrayList<ResolvedTypeForSymbol>();
            try {
                Path filePath = PathUtil.getPathFromURI(fileUri).orElseThrow();
                SemanticModel semanticModel = (SemanticModel)this.workspaceManagerProxy.get(fileUri).semanticModel(filePath).orElseThrow();
                Document document = (Document)this.workspaceManagerProxy.get(fileUri).document(filePath).orElseThrow();
                LinePosition fnPosition = request.getFnPosition();
                Symbol fnSymbol = (Symbol)semanticModel.symbol(document, fnPosition).orElseThrow();
                if (fnSymbol instanceof FunctionSymbol) {
                    FunctionSymbol functionSymbol = (FunctionSymbol)fnSymbol;
                    FunctionTypeSymbol fnTypeSymbol = functionSymbol.typeDescriptor();
                    Optional<ResolvedTypeForSymbol> returnType = this.getTypeForReturnTypeDesc(fnTypeSymbol, request.getReturnTypeDescPosition());
                    returnType.ifPresent(types::add);
                    List<ResolvedTypeForSymbol> paramTypes = this.getTypesForFnParams(fnTypeSymbol);
                    types.addAll(paramTypes);
                }
                typeFromSymbolResponse.setTypes(types);
                return typeFromSymbolResponse;
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaSymbol/getTypesFromFnDefinition' failed!";
                this.clientLogger.logError(SymbolContext.SC_GET_TYPE_FROM_FN_DEFINITION_API, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return typeFromSymbolResponse;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<SymbolInfoResponse> getSymbol(SymbolInfoRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            SymbolInfoResponse symbolInfoResponse = new SymbolInfoResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
            if (filePath.isEmpty()) {
                return symbolInfoResponse;
            }
            try {
                Optional semanticModel = this.workspaceManagerProxy.get(fileUri).semanticModel(filePath.get());
                if (semanticModel.isEmpty()) {
                    return symbolInfoResponse;
                }
                DocumentServiceContext context = ContextBuilder.buildDocumentServiceContext(fileUri, this.workspaceManagerProxy.get(fileUri), LSContextOperation.SYMBOL_DOCUMENT, this.serverContext);
                Optional srcFile = context.currentDocument();
                if (srcFile.isEmpty()) {
                    return symbolInfoResponse;
                }
                LinePosition linePosition = LinePosition.from((int)request.getPosition().getLine(), (int)request.getPosition().getCharacter());
                Optional symbolAtCursor = ((SemanticModel)semanticModel.get()).symbol((Document)srcFile.get(), linePosition);
                Range nodeRange = new Range(request.getPosition(), request.getPosition());
                NonTerminalNode nodeAtCursor = CommonUtil.findNode(nodeRange, ((Document)srcFile.get()).syntaxTree());
                if (symbolAtCursor.isEmpty()) {
                    MatchedExpressionNodeResolver exprResolver;
                    Optional<ExpressionNode> expr;
                    if (nodeAtCursor != null && (expr = (exprResolver = new MatchedExpressionNodeResolver((Node)nodeAtCursor)).findExpression((Node)nodeAtCursor)).isPresent()) {
                        return this.getDocMetadataForNewExpression((Node)expr.get(), context, symbolInfoResponse, nodeAtCursor);
                    }
                    return symbolInfoResponse;
                }
                return this.getSymbolDocMetadata((Symbol)symbolAtCursor.get(), symbolInfoResponse, context, nodeAtCursor);
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaSymbol/getSymbol' failed!";
                this.clientLogger.logError(SymbolContext.SC_GET_SYMBOL_API, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return symbolInfoResponse;
            }
        });
    }

    private List<String> getAllUnionTypes(Symbol symbol) {
        ArrayList<String> allTypes = new ArrayList<String>();
        if (symbol.kind() == SymbolKind.VARIABLE) {
            VariableSymbol variableSymbol = (VariableSymbol)symbol;
            if (variableSymbol.typeDescriptor().typeKind() == TypeDescKind.UNION) {
                UnionTypeSymbol ballerinaUnionTypeSymbol = (UnionTypeSymbol)variableSymbol.typeDescriptor();
                for (TypeSymbol typeSymbol : ballerinaUnionTypeSymbol.memberTypeDescriptors()) {
                    if (allTypes.contains(typeSymbol.typeKind().getName())) continue;
                    allTypes.add(typeSymbol.typeKind().getName());
                }
            } else if (variableSymbol.typeDescriptor().typeKind() == TypeDescKind.TYPE_REFERENCE) {
                allTypes.add((String)variableSymbol.typeDescriptor().getName().get());
            } else {
                allTypes.add(variableSymbol.typeDescriptor().typeKind().getName());
            }
        } else if (symbol.kind() == SymbolKind.METHOD) {
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            TypeSymbol returnTypeSymbol = (TypeSymbol)methodSymbol.typeDescriptor().returnTypeDescriptor().get();
            if (returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
                UnionTypeSymbol ballerinaUnionTypeSymbol = (UnionTypeSymbol)returnTypeSymbol;
                for (TypeSymbol typeSymbol : ballerinaUnionTypeSymbol.memberTypeDescriptors()) {
                    if (allTypes.contains(typeSymbol.typeKind().getName())) continue;
                    allTypes.add(typeSymbol.typeKind().getName());
                }
            } else {
                allTypes.add(returnTypeSymbol.typeKind().getName());
            }
        }
        return allTypes;
    }

    private SymbolInfoResponse getDocMetadataForNewExpression(Node exprNode, DocumentServiceContext context, SymbolInfoResponse symbolInfoResponse, NonTerminalNode nodeAtCursor) {
        switch (exprNode.kind()) {
            case IMPLICIT_NEW_EXPRESSION: 
            case EXPLICIT_NEW_EXPRESSION: {
                ClassSymbol classSymbol;
                Optional<TypeSymbol> optionalTypeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf(exprNode)).map(CommonUtil::getRawType);
                if (optionalTypeSymbol.isEmpty()) break;
                TypeSymbol typeSymbol = optionalTypeSymbol.get();
                if (typeSymbol.typeKind() == TypeDescKind.UNION) {
                    UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                    Optional<TypeSymbol> classTypeSymbol = unionTypeSymbol.memberTypeDescriptors().stream().map(CommonUtil::getRawType).filter(member -> member.typeKind() != TypeDescKind.ERROR).findFirst();
                    if (classTypeSymbol.isEmpty()) break;
                    typeSymbol = classTypeSymbol.get();
                }
                if (!(typeSymbol instanceof ClassSymbol) || (classSymbol = (ClassSymbol)typeSymbol).initMethod().isEmpty()) break;
                MethodSymbol initMethodSymbol = (MethodSymbol)classSymbol.initMethod().get();
                return this.getSymbolDocMetadata((Symbol)initMethodSymbol, symbolInfoResponse, context, nodeAtCursor);
            }
        }
        return symbolInfoResponse;
    }

    private SymbolInfoResponse getSymbolDocMetadata(Symbol symbolAtCursor, SymbolInfoResponse symbolInfoResponse, DocumentServiceContext context, NonTerminalNode nodeAtCursor) {
        Optional documentation;
        Optional optional = documentation = symbolAtCursor instanceof Documentable ? ((Documentable)symbolAtCursor).documentation() : Optional.empty();
        if (documentation.isEmpty()) {
            return symbolInfoResponse;
        }
        ArrayList<SymbolDocumentation.ParameterInfo> symbolParams = new ArrayList<SymbolDocumentation.ParameterInfo>();
        if (symbolAtCursor instanceof FunctionSymbol) {
            Optional restParam;
            FunctionSymbol functionSymbol = (FunctionSymbol)symbolAtCursor;
            if (functionSymbol.typeDescriptor().params().isPresent()) {
                List parameterSymbolList = (List)functionSymbol.typeDescriptor().params().get();
                parameterSymbolList.subList(this.skipFirstParam(symbolAtCursor, nodeAtCursor) ? 1 : 0, parameterSymbolList.size()).stream().filter(parameterSymbol -> parameterSymbol.getName().isPresent()).forEach(parameterSymbol -> symbolParams.add(new SymbolDocumentation.ParameterInfo((String)parameterSymbol.getName().get(), (String)((Documentation)documentation.get()).parameterMap().get(parameterSymbol.getName().get()), parameterSymbol.paramKind().name(), NameUtil.getModifiedTypeName(context, parameterSymbol.typeDescriptor()))));
            }
            if ((restParam = functionSymbol.typeDescriptor().restParam()).isPresent() && ((ParameterSymbol)restParam.get()).getName().isPresent()) {
                ParameterSymbol restParameter = (ParameterSymbol)restParam.get();
                symbolParams.add(new SymbolDocumentation.ParameterInfo((String)restParameter.getName().get(), (String)((Documentation)documentation.get()).parameterMap().get(restParameter.getName().get()), restParameter.paramKind().name(), NameUtil.getModifiedTypeName(context, restParameter.typeDescriptor())));
            }
        }
        ArrayList<SymbolDocumentation.ParameterInfo> deprecatedParams = new ArrayList<SymbolDocumentation.ParameterInfo>(((Documentation)documentation.get()).deprecatedParametersMap().size());
        Map deprecatedParamMap = ((Documentation)documentation.get()).deprecatedParametersMap();
        deprecatedParamMap.forEach((param, desc) -> deprecatedParams.add(new SymbolDocumentation.ParameterInfo((String)param, (String)desc)));
        SymbolDocumentation symbolDoc = new SymbolDocumentation((Documentation)documentation.get(), symbolParams, deprecatedParams);
        symbolInfoResponse.setSymbolDocumentation(symbolDoc);
        symbolInfoResponse.setSymbolKind(symbolAtCursor.kind());
        return symbolInfoResponse;
    }

    private boolean skipFirstParam(Symbol symbolAtCursor, NonTerminalNode nodeAtCursor) {
        return (symbolAtCursor.kind() == SymbolKind.FUNCTION || symbolAtCursor.kind() == SymbolKind.METHOD) && symbolAtCursor.getModule().isPresent() && CommonUtil.isLangLib(((ModuleSymbol)symbolAtCursor.getModule().get()).id()) && nodeAtCursor.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE;
    }

    private Optional<ResolvedTypeForSymbol> getTypeForReturnTypeDesc(FunctionTypeSymbol functionTypeSymbol, LinePosition typeDescPosition) {
        Optional typeSymbol = functionTypeSymbol.returnTypeDescriptor();
        if (typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        ResolvedTypeForSymbol resolvedType = new ResolvedTypeForSymbol(typeDescPosition);
        Type type = Type.fromSemanticSymbol((Symbol)((Symbol)typeSymbol.get()));
        Type.clearParentSymbols();
        resolvedType.setType(type);
        return Optional.of(resolvedType);
    }

    private List<ResolvedTypeForSymbol> getTypesForFnParams(FunctionTypeSymbol fnTypeSymbol) {
        ArrayList<ResolvedTypeForSymbol> types = new ArrayList<ResolvedTypeForSymbol>();
        Optional params = fnTypeSymbol.params();
        if (params.isPresent()) {
            for (ParameterSymbol param : (List)params.get()) {
                Optional location = param.getLocation();
                if (!location.isPresent()) continue;
                LinePosition paramPosition = ((Location)location.get()).lineRange().startLine();
                ResolvedTypeForSymbol resolvedType = new ResolvedTypeForSymbol(paramPosition);
                Type type = Type.fromSemanticSymbol((Symbol)param);
                Type.clearParentSymbols();
                resolvedType.setType(type);
                types.add(resolvedType);
            }
        }
        return types;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }
}

