/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.symbol;

import io.ballerina.compiler.api.symbols.Documentation;
import java.util.List;

public class SymbolDocumentation {
    private final String description;
    private final List<ParameterInfo> parameters;
    private final String returnValueDescription;
    private final String deprecatedDocumentation;
    private final List<ParameterInfo> deprecatedParams;

    public SymbolDocumentation(Documentation documentation, List<ParameterInfo> parameters, List<ParameterInfo> deprecatedParams) {
        this.description = documentation.description().isEmpty() ? null : (String)documentation.description().get();
        this.parameters = parameters.isEmpty() ? null : parameters;
        this.returnValueDescription = documentation.returnDescription().isEmpty() ? null : (String)documentation.returnDescription().get();
        this.deprecatedDocumentation = documentation.deprecatedDescription().isEmpty() ? null : (String)documentation.deprecatedDescription().get();
        this.deprecatedParams = deprecatedParams.isEmpty() ? null : deprecatedParams;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public String getReturnValueDescription() {
        return this.returnValueDescription;
    }

    public String getDeprecatedDocumentation() {
        return this.deprecatedDocumentation;
    }

    public List<ParameterInfo> getDeprecatedParams() {
        return this.deprecatedParams;
    }

    public static class ParameterInfo {
        public String name;
        public String description;
        public String kind;
        public String type;

        public ParameterInfo(String name, String description, String kind, String type) {
            this.name = name;
            this.description = description;
            this.kind = kind;
            this.type = type;
        }

        public ParameterInfo(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getKind() {
            return this.kind;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

