/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.references;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;

public class DocumentationReferenceFinder
extends NodeTransformer<List<NodeLocation>> {
    private final Symbol symbol;

    public DocumentationReferenceFinder(Symbol symbol) {
        this.symbol = symbol;
    }

    public List<NodeLocation> transform(RequiredParameterNode node) {
        Optional<FunctionDefinitionNode> fnDefNode = CodeActionUtil.getEnclosedFunction((Node)node);
        if (fnDefNode.isEmpty()) {
            return Collections.emptyList();
        }
        Optional documentationNode = fnDefNode.get().metadata().flatMap(metadataNode -> metadataNode.documentationString());
        if (documentationNode.isEmpty() || ((Node)documentationNode.get()).kind() != SyntaxKind.MARKDOWN_DOCUMENTATION) {
            return Collections.emptyList();
        }
        return this.getParameterLocations((MarkdownDocumentationNode)documentationNode.get());
    }

    public List<NodeLocation> transform(RecordFieldNode node) {
        if (node.parent().parent().kind() != SyntaxKind.TYPE_DEFINITION) {
            return Collections.emptyList();
        }
        TypeDefinitionNode typeDefNode = (TypeDefinitionNode)node.parent().parent();
        Optional documentationNode = typeDefNode.metadata().flatMap(metadataNode -> metadataNode.documentationString());
        if (documentationNode.isEmpty() || ((Node)documentationNode.get()).kind() != SyntaxKind.MARKDOWN_DOCUMENTATION) {
            return Collections.emptyList();
        }
        return this.getParameterLocations((MarkdownDocumentationNode)documentationNode.get());
    }

    private List<NodeLocation> getParameterLocations(MarkdownDocumentationNode mdNode) {
        return mdNode.documentationLines().stream().filter(line -> line.kind() == SyntaxKind.MARKDOWN_PARAMETER_DOCUMENTATION_LINE).map(line -> (MarkdownParameterDocumentationLineNode)line).map(line -> line.parameterName()).filter(token -> token.text().equals(this.symbol.getName().get())).map(paramToken -> paramToken.location()).toList();
    }

    protected List<NodeLocation> transformSyntaxNode(Node node) {
        return Collections.emptyList();
    }
}

