/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.references;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.references.DocumentationReferenceFinder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class ReferencesUtil {
    private ReferencesUtil() {
    }

    public static Map<Module, List<Location>> getReferences(PositionedOperationContext context) {
        HashMap<Module, List<Location>> references = new HashMap<Module, List<Location>>();
        Optional project = context.workspace().project(context.filePath());
        Optional<Symbol> symbol = ReferencesUtil.getSymbolAtCursor(context);
        if (project.isEmpty() || symbol.isEmpty()) {
            return references;
        }
        references.putAll(ReferencesUtil.getReferences((Project)project.get(), symbol.get()));
        references.forEach((module, locations) -> {
            LinkedList docReferences = new LinkedList();
            locations.forEach(location -> {
                List<NodeLocation> refs = ReferencesUtil.findReferencesInDocumentation(location, module, context, (Symbol)symbol.get());
                if (refs != null && !refs.isEmpty()) {
                    docReferences.addAll(refs);
                }
            });
            locations.addAll(docReferences);
        });
        return references;
    }

    public static Map<Module, List<Location>> getReferences(Project project, Symbol symbol) {
        HashMap<Module, List<Location>> moduleLocationMap = new HashMap<Module, List<Location>>();
        project.currentPackage().moduleIds().forEach(moduleId -> {
            List references = project.currentPackage().getCompilation().getSemanticModel(moduleId).references(symbol);
            if (references.isEmpty()) {
                return;
            }
            Module module = project.currentPackage().module(moduleId);
            moduleLocationMap.put(module, references);
        });
        return moduleLocationMap;
    }

    private static List<NodeLocation> findReferencesInDocumentation(Location location, Module module, PositionedOperationContext context, Symbol symbol) {
        Path filePath = PathUtil.getPathFromLocation(module, location);
        Range range = PositionUtil.getRangeFromLineRange(location.lineRange());
        Optional<NonTerminalNode> node = context.workspace().syntaxTree(filePath).map(syntaxTree -> CommonUtil.findNode(range, syntaxTree));
        if (node.isEmpty() || node.get().kind() == SyntaxKind.LIST) {
            return Collections.emptyList();
        }
        DocumentationReferenceFinder finder = new DocumentationReferenceFinder(symbol);
        return (List)node.get().apply((NodeTransformer)finder);
    }

    public static Optional<Symbol> getSymbolAtCursor(PositionedOperationContext context) {
        Optional srcFile = context.currentDocument();
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty() || srcFile.isEmpty()) {
            return Optional.empty();
        }
        Document document = (Document)srcFile.get();
        Position position = context.getCursorPosition();
        TextRange range = TextRange.from((int)document.textDocument().textPositionFrom(PositionUtil.getLinePosition(position)), (int)0);
        NonTerminalNode nonTerminalNode = ((ModulePartNode)document.syntaxTree().rootNode()).findNode(range);
        SyntaxKind parentKind = nonTerminalNode.parent().kind();
        if ((parentKind == SyntaxKind.TYPE_PARAMETER || parentKind == SyntaxKind.STREAM_TYPE_PARAMS) && nonTerminalNode.lineRange().endLine().offset() == position.getCharacter()) {
            return ((SemanticModel)semanticModel.get()).symbol(document, LinePosition.from((int)position.getLine(), (int)(position.getCharacter() - 1)));
        }
        Optional symbolAtCursor = ((SemanticModel)semanticModel.get()).symbol((Document)srcFile.get(), LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        if (symbolAtCursor.isEmpty()) {
            if (position.getCharacter() == 0) {
                return Optional.empty();
            }
            symbolAtCursor = ((SemanticModel)semanticModel.get()).symbol((Document)srcFile.get(), LinePosition.from((int)position.getLine(), (int)(position.getCharacter() - 1)));
            if (symbolAtCursor.isEmpty()) {
                return Optional.empty();
            }
        }
        return symbolAtCursor;
    }
}

