/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.semantictokens;

import io.ballerina.projects.Document;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.SemanticTokensContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.semantictokens.SemanticTokensConstants;
import org.ballerinalang.langserver.semantictokens.SemanticTokensVisitor;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensServerFull;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;

public final class SemanticTokensUtils {
    private SemanticTokensUtils() {
    }

    public static SemanticTokens getSemanticTokens(SemanticTokensContext semanticTokensContext) {
        String fileUri = semanticTokensContext.fileUri();
        Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
        if (filePath.isEmpty()) {
            return new SemanticTokens(Collections.emptyList());
        }
        Optional document = semanticTokensContext.currentDocument();
        if (document.isEmpty()) {
            return new SemanticTokens(Collections.emptyList());
        }
        return new SemanticTokensVisitor(semanticTokensContext).getSemanticTokens(((Document)document.get()).syntaxTree().rootNode());
    }

    public static List<String> getTokenTypes() {
        return Arrays.stream(SemanticTokensContext.TokenTypes.values()).map(SemanticTokensContext.TokenTypes::getValue).toList();
    }

    public static List<String> getTokenTypeModifiers() {
        return Arrays.stream(SemanticTokensContext.TokenTypeModifiers.values()).map(SemanticTokensContext.TokenTypeModifiers::getValue).toList();
    }

    public static SemanticTokensWithRegistrationOptions getSemanticTokensRegistrationOptions() {
        SemanticTokensLegend semanticTokensLegend = new SemanticTokensLegend(SemanticTokensUtils.getTokenTypes(), SemanticTokensUtils.getTokenTypeModifiers());
        return new SemanticTokensWithRegistrationOptions(semanticTokensLegend, new SemanticTokensServerFull(Boolean.valueOf(false)));
    }

    public static void registerSemanticTokensCapability(ExtendedLanguageClient languageClient) {
        if (languageClient == null) {
            return;
        }
        SemanticTokensWithRegistrationOptions options = SemanticTokensUtils.getSemanticTokensRegistrationOptions();
        Registration registration = new Registration(SemanticTokensConstants.REGISTRATION_ID, "textDocument/semanticTokens", (Object)options);
        languageClient.registerCapability(new RegistrationParams(Collections.singletonList(registration)));
    }

    public static void unRegisterSemanticTokensCapability(ExtendedLanguageClient languageClient) {
        if (languageClient == null) {
            return;
        }
        Unregistration unregistration = new Unregistration(SemanticTokensConstants.REGISTRATION_ID, "textDocument/semanticTokens");
        languageClient.unregisterCapability(new UnregistrationParams(Collections.singletonList(unregistration)));
    }
}

