/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.signature;

import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.commons.SignatureContext;
import org.ballerinalang.langserver.signature.Parameter;
import org.ballerinalang.langserver.signature.ParameterInfoModel;
import org.ballerinalang.langserver.util.MarkupUtils;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SignatureInformationCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.wso2.ballerinalang.compiler.util.Names;

public class SignatureInfoModelBuilder {
    private final Symbol symbol;
    private final SignatureContext context;
    private final List<ParameterInfoModel> parameterModels;
    private List<ParameterInfoModel> includedRecordParams;
    private Either<String, MarkupContent> signatureDescription;
    private final Map<String, String> paramsMap = new HashMap<String, String>();

    public SignatureInfoModelBuilder(Symbol symbol, SignatureContext context) {
        this.symbol = symbol;
        this.context = context;
        this.parameterModels = new ArrayList<ParameterInfoModel>();
        this.includedRecordParams = new ArrayList<ParameterInfoModel>();
        this.fillParamInfoModels();
    }

    public List<SignatureInformation> build() {
        int labelOffset;
        ArrayList<SignatureInformation> result = new ArrayList<SignatureInformation>();
        StringBuilder defaultLabelBuilder = new StringBuilder(this.getFunctionName());
        defaultLabelBuilder.append("(");
        ArrayList<ParameterInformation> defaultSignatureParamInfo = new ArrayList<ParameterInformation>();
        ArrayList<ParameterInformation> expandedSignatureParamInfo = new ArrayList<ParameterInformation>();
        StringBuilder expandedModelPrefix = new StringBuilder();
        for (int i = 0; i < this.parameterModels.size(); ++i) {
            ParameterInfoModel paramModel = this.parameterModels.get(i);
            labelOffset = defaultLabelBuilder.toString().length();
            if (!this.includedRecordParams.isEmpty() && this.includedRecordParams.get(0).equals(paramModel)) {
                expandedModelPrefix.append(defaultLabelBuilder.toString());
            }
            String parameterType = paramModel.getParameter().getType();
            Optional<String> parameterName = paramModel.getParameter().getName();
            defaultLabelBuilder.append(parameterType);
            ParameterInformation paramInfo = new ParameterInformation();
            MarkupContent parameterDocumentation = this.getParameterDocumentation(parameterType, parameterName.orElse(""), paramModel.getDescription());
            paramInfo.setDocumentation(parameterDocumentation);
            int paramStart = labelOffset;
            int paramEnd = labelOffset + parameterType.length();
            if (parameterName.isPresent()) {
                paramStart = paramEnd + 1;
                paramEnd += (parameterName.get() + " ").length();
                defaultLabelBuilder.append(" ").append(parameterName.get());
            }
            if (i < this.parameterModels.size() - 1) {
                defaultLabelBuilder.append(", ");
            }
            paramInfo.setLabel(Tuple.two((Object)paramStart, (Object)paramEnd));
            defaultSignatureParamInfo.add(paramInfo);
            if (this.includedRecordParams.isEmpty() || paramModel.isIncludedRecordParam()) continue;
            expandedSignatureParamInfo.add(paramInfo);
        }
        if (!this.includedRecordParams.isEmpty()) {
            int firstIncludedRecordParamIndex = this.parameterModels.indexOf(this.includedRecordParams.get(0));
            ArrayList<String> expandedParamList = new ArrayList<String>();
            labelOffset = expandedModelPrefix.toString().length();
            for (int i = 0; i < this.includedRecordParams.size(); ++i) {
                ParameterInfoModel includedParamInfo = this.includedRecordParams.get(i);
                TypeSymbol paramTypeSymbol = includedParamInfo.getParameter().getParameterSymbol().typeDescriptor();
                Pair<String, List<ParameterInformation>> includedRecordParamInfo = this.getIncludedRecordParamInfo(paramTypeSymbol, labelOffset);
                if (((List)includedRecordParamInfo.getValue()).isEmpty()) continue;
                expandedParamList.add((String)includedRecordParamInfo.getKey());
                expandedSignatureParamInfo.addAll((Collection)includedRecordParamInfo.getValue());
                labelOffset += ((String)includedRecordParamInfo.getKey()).length();
                if (firstIncludedRecordParamIndex + i >= this.parameterModels.size() - 1) continue;
                labelOffset += 2;
            }
            if (!expandedParamList.isEmpty()) {
                StringBuilder expandedLabelBuilder = new StringBuilder(expandedModelPrefix.toString());
                expandedLabelBuilder.append(String.join((CharSequence)", ", expandedParamList)).append(")");
                result.add(this.getSignatureInfo(expandedLabelBuilder.toString(), expandedSignatureParamInfo));
            }
        }
        defaultLabelBuilder.append(")");
        result.add(this.getSignatureInfo(defaultLabelBuilder.toString(), defaultSignatureParamInfo));
        return result;
    }

    private SignatureInformation getSignatureInfo(String label, List<ParameterInformation> parameters) {
        SignatureInformation expandedSignatureInfo = new SignatureInformation();
        expandedSignatureInfo.setDocumentation(this.signatureDescription);
        expandedSignatureInfo.setLabel(label);
        expandedSignatureInfo.setParameters(parameters);
        return expandedSignatureInfo;
    }

    private void fillParamInfoModels() {
        this.fillDescriptionModels();
        Optional<FunctionTypeSymbol> functionTypeSymbol = this.getFunctionType(this.symbol);
        List parameterSymbols = functionTypeSymbol.map(typeSymbol -> typeSymbol.params().orElse(new ArrayList())).orElse(Collections.emptyList());
        if (parameterSymbols.isEmpty()) {
            return;
        }
        Optional restParam = functionTypeSymbol.flatMap(FunctionTypeSymbol::restParam);
        List<Parameter> parameters = Stream.concat(parameterSymbols.subList(this.skipFirstParam() ? 1 : 0, parameterSymbols.size()).stream().map(param -> new Parameter((ParameterSymbol)param, false, false, this.context)), restParam.stream().map(parameter -> new Parameter((ParameterSymbol)parameter, false, true, this.context))).toList();
        for (Parameter param2 : parameters) {
            String desc = param2.getName().isPresent() && this.paramsMap.containsKey(param2.getName().get()) ? this.paramsMap.get(param2.getName().get()) : "";
            this.parameterModels.add(new ParameterInfoModel(param2, desc));
        }
        this.includedRecordParams = this.parameterModels.stream().filter(ParameterInfoModel::isIncludedRecordParam).toList();
    }

    private boolean skipFirstParam() {
        return (this.symbol.kind() == SymbolKind.FUNCTION || this.symbol.kind() == SymbolKind.METHOD) && this.symbol.getModule().isPresent() && CommonUtil.isLangLib(((ModuleSymbol)this.symbol.getModule().get()).id());
    }

    private void fillDescriptionModels() {
        Optional documentation;
        Optional optional = documentation = this.symbol instanceof Documentable ? ((Documentable)this.symbol).documentation() : Optional.empty();
        if (documentation.isEmpty()) {
            return;
        }
        if (((Documentation)documentation.get()).description().isPresent()) {
            this.setSignatureDescription(((String)((Documentation)documentation.get()).description().get()).trim(), this.context);
        }
        ((Documentation)documentation.get()).parameterMap().forEach(this.paramsMap::put);
    }

    private void setSignatureDescription(String signatureDescription, SignatureContext signatureContext) {
        List documentationFormat;
        SignatureInformationCapabilities capabilities = signatureContext.capabilities().getSignatureInformation();
        List list = documentationFormat = capabilities != null ? capabilities.getDocumentationFormat() : new ArrayList();
        if (documentationFormat != null && !documentationFormat.isEmpty() && ((String)documentationFormat.get(0)).equals("markdown")) {
            MarkupContent signatureMarkupContent = new MarkupContent();
            signatureMarkupContent.setKind("markdown");
            signatureMarkupContent.setValue(MarkupUtils.boldString("Description") + CommonUtil.MD_LINE_SEPARATOR + signatureDescription);
            this.signatureDescription = Either.forRight((Object)signatureMarkupContent);
        } else {
            this.signatureDescription = Either.forLeft((Object)("Description" + CommonUtil.LINE_SEPARATOR + signatureDescription));
        }
    }

    private Pair<String, List<ParameterInformation>> getIncludedRecordParamInfo(TypeSymbol typeSymbol, int startOffset) {
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
        if (rawType.typeKind() != TypeDescKind.RECORD) {
            return Pair.of(null, null);
        }
        StringBuilder paramLabelBuilder = new StringBuilder();
        Map<String, String> parameterDocumentation = this.getParameterDocumentationMap((Symbol)typeSymbol);
        ArrayList<ParameterInformation> parameterInformationList = new ArrayList<ParameterInformation>();
        ArrayList fieldSymbols = new ArrayList(((RecordTypeSymbol)rawType).fieldDescriptors().values());
        for (int i = 0; i < fieldSymbols.size(); ++i) {
            RecordFieldSymbol recordFieldSymbol = (RecordFieldSymbol)fieldSymbols.get(i);
            TypeSymbol fieldType = recordFieldSymbol.typeDescriptor();
            if (fieldType.typeKind() == TypeDescKind.NEVER) continue;
            int labelOffset = startOffset + paramLabelBuilder.length();
            ParameterInformation paramInfo = new ParameterInformation();
            Optional fieldName = recordFieldSymbol.getName();
            String paramDocs = parameterDocumentation.getOrDefault(fieldName.orElse(""), recordFieldSymbol.signature());
            String typeSignature = fieldType.signature();
            MarkupContent parameterDocs = this.getParameterDocumentation(typeSignature, fieldName.orElse(""), paramDocs);
            paramInfo.setDocumentation(parameterDocs);
            typeSignature = FunctionGenerator.processModuleIDsInText(typeSignature);
            paramLabelBuilder.append(typeSignature);
            int paramStart = labelOffset;
            int paramEnd = labelOffset + typeSignature.length();
            if (fieldName.isPresent()) {
                paramStart = paramEnd + 1;
                paramEnd += 1 + ((String)fieldName.get()).length();
                paramLabelBuilder.append(" ").append((String)fieldName.get());
            }
            if (i < fieldSymbols.size() - 1) {
                paramLabelBuilder.append(", ");
            }
            paramInfo.setLabel(Tuple.two((Object)paramStart, (Object)paramEnd));
            parameterInformationList.add(paramInfo);
        }
        return Pair.of((Object)paramLabelBuilder.toString(), parameterInformationList);
    }

    private String getFunctionName() {
        String functionName = (String)this.symbol.getName().get();
        Optional nodeAtCursor = this.context.getNodeAtCursor();
        SyntaxKind syntaxKind = ((NonTerminalNode)nodeAtCursor.get()).kind();
        if (functionName.equals(Names.USER_DEFINED_INIT_SUFFIX.getValue()) && (syntaxKind == SyntaxKind.IMPLICIT_NEW_EXPRESSION || syntaxKind == SyntaxKind.EXPLICIT_NEW_EXPRESSION)) {
            return SyntaxKind.NEW_KEYWORD.stringValue();
        }
        return functionName;
    }

    private Map<String, String> getParameterDocumentationMap(Symbol symbol) {
        if (symbol.kind() != SymbolKind.TYPE || ((TypeSymbol)symbol).typeKind() != TypeDescKind.TYPE_REFERENCE || ((Documentable)((TypeReferenceTypeSymbol)symbol).definition()).documentation().isEmpty()) {
            return Collections.emptyMap();
        }
        Documentation documentation = (Documentation)((Documentable)((TypeReferenceTypeSymbol)symbol).definition()).documentation().get();
        return Collections.unmodifiableMap(documentation.parameterMap());
    }

    private MarkupContent getParameterDocumentation(String type, String paramName, String description) {
        MarkupContent paramDocumentation = new MarkupContent();
        paramDocumentation.setKind("markdown");
        StringBuilder markupContent = new StringBuilder();
        markupContent.append(MarkupUtils.boldString("Parameter")).append(CommonUtil.MD_LINE_SEPARATOR).append(MarkupUtils.boldString(MarkupUtils.quotedString(type) + paramName));
        if (!description.isBlank()) {
            markupContent.append(": ").append(description);
        }
        paramDocumentation.setValue(markupContent.toString());
        return paramDocumentation;
    }

    private Optional<FunctionTypeSymbol> getFunctionType(Symbol symbol) {
        TypeSymbol type;
        switch (symbol.kind()) {
            case FUNCTION: 
            case METHOD: 
            case RESOURCE_METHOD: {
                return Optional.of(((FunctionSymbol)symbol).typeDescriptor());
            }
            case VARIABLE: {
                type = ((VariableSymbol)symbol).typeDescriptor();
                break;
            }
            case PARAMETER: {
                type = ((ParameterSymbol)symbol).typeDescriptor();
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        if (type.typeKind() == TypeDescKind.FUNCTION) {
            return Optional.of((FunctionTypeSymbol)type);
        }
        return Optional.empty();
    }
}

