/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.deserializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.deserializers.AbstractDeserializer;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import java.io.IOException;

public class BytesDeserializer
extends AbstractDeserializer {
    public BytesDeserializer(CodedInputStream input, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage, Type targetType) {
        super(input, fieldDescriptor, bMessage, targetType);
    }

    @Override
    public void deserialize() throws IOException {
        BString bFieldName = StringUtils.fromString((String)this.fieldDescriptor.getName());
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (this.fieldDescriptor.getContainingOneof() != null) {
                bMap.put((Object)StringUtils.fromString((String)this.fieldDescriptor.getName()), (Object)this.readContent());
            } else {
                bMap.put((Object)bFieldName, (Object)this.readContent());
            }
        } else {
            this.bMessage.setContent(this.readContent());
        }
    }

    private BArray readContent() throws IOException {
        return ValueCreator.createArrayValue((byte[])this.input.readByteArray());
    }
}

