/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.deserializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.AnydataType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.deserializers.AbstractDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.DeserializeHandler;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import java.io.IOException;
import java.util.Arrays;

public class MessageDeserializer
extends AbstractDeserializer {
    public MessageDeserializer(CodedInputStream input, Descriptors.FieldDescriptor fieldDescriptor, Type type, BMessage bMessage, Type targetType) {
        super(input, fieldDescriptor, bMessage, targetType, type);
    }

    @Override
    public void deserialize() throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        RecordType recordType;
        if (this.messageType instanceof RecordType) {
            recordType = (RecordType)this.messageType;
        } else if (this.messageType instanceof MapType || this.messageType instanceof TupleType || this.messageType instanceof AnydataType || this.messageType.getTag() == TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANYDATA).getTag()) {
            recordType = null;
        } else {
            throw new IOException("Error while decoding request message. record type is not supported : " + String.valueOf(this.fieldDescriptor.getType()));
        }
        BString bFieldName = StringUtils.fromString((String)this.fieldDescriptor.getName());
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (this.fieldDescriptor.getFullName().equals("google.protobuf.Struct.fields") || this.fieldDescriptor.getFullName().equals("google.protobuf.StructValue.values")) {
                TupleType messageType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_STRING, PredefinedTypes.TYPE_ANYDATA));
                BArray tupleVal = (BArray)this.readMessage((Type)messageType);
                bMap.put((Object)tupleVal.getBString(0L), tupleVal.get(1L));
                this.bMessage.setContent(bMap);
            } else if (this.fieldDescriptor.isRepeated() && recordType != null) {
                BArray valueArray = bMap.get((Object)bFieldName) != null ? (BArray)bMap.get((Object)bFieldName) : null;
                Type fieldType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
                if (valueArray == null || valueArray.size() == 0) {
                    valueArray = ValueCreator.createArrayValue((ArrayType)((ArrayType)fieldType));
                    bMap.put((Object)bFieldName, (Object)valueArray);
                }
                valueArray.add((long)valueArray.size(), this.readMessage(TypeUtils.getReferredType((Type)((ArrayType)fieldType).getElementType())));
                this.bMessage.setContent(bMap);
            } else if (this.fieldDescriptor.getContainingOneof() != null && recordType != null) {
                Type messageType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
                Object bValue = this.readMessage(messageType);
                bMap.put((Object)StringUtils.fromString((String)this.fieldDescriptor.getName()), bValue);
                this.bMessage.setContent(bMap);
            } else if (this.fieldDescriptor.getMessageType().getFullName().equals("google.protobuf.Struct") && recordType != null) {
                MapType messageType = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA);
                bMap.put((Object)bFieldName, this.readMessage((Type)messageType));
                this.bMessage.setContent(bMap);
            } else if (recordType != null) {
                Type messageType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
                bMap.put((Object)bFieldName, this.readMessage(messageType));
            }
        } else if (this.fieldDescriptor.getFullName().equals("google.protobuf.Struct.FieldsEntry.value")) {
            BArray bArray = (BArray)this.bMessage.getContent();
            bArray.add(1L, this.readMessage((Type)PredefinedTypes.TYPE_ANYDATA));
        } else if (this.fieldDescriptor.getFullName().equals("google.protobuf.Value.list_value")) {
            this.bMessage.setContent(this.readMessage((Type)PredefinedTypes.TYPE_ANYDATA));
        } else if (this.fieldDescriptor.getFullName().equals("google.protobuf.ListValue.values")) {
            BArray bArray = (BArray)this.bMessage.getContent();
            bArray.add((long)bArray.size(), this.readMessage((Type)PredefinedTypes.TYPE_ANYDATA));
        } else if (this.fieldDescriptor.getFullName().equals("google.protobuf.Value.struct_value")) {
            this.bMessage.setContent(this.readMessage((Type)PredefinedTypes.TYPE_ANYDATA));
        } else if (recordType != null) {
            Type messageType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
            this.bMessage.setContent(this.readMessage(messageType));
        }
    }

    private Object readMessage(Type messageType) throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        int length = this.input.readRawVarint32();
        int limit = this.input.pushLimit(length);
        DeserializeHandler deserializeHandler = new DeserializeHandler(this.fieldDescriptor, this.input, this.targetType, messageType);
        deserializeHandler.deserialize();
        this.input.popLimit(limit);
        return deserializeHandler.getBMessage();
    }
}

