/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import java.io.IOException;

public abstract class AbstractSerializer {
    protected CodedOutputStream output;
    protected Descriptors.FieldDescriptor fieldDescriptor;
    protected BMessage bMessage;
    protected BString bFieldName;
    protected String messageName;

    public abstract void computeMessageSize() throws Descriptors.DescriptorValidationException, IOException, AnnotationUnavailableException;

    public abstract void serialize() throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException;

    protected AbstractSerializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        this.fieldDescriptor = fieldDescriptor;
        this.bMessage = bMessage;
        this.bFieldName = StringUtils.fromString((String)fieldDescriptor.getName());
        this.output = output;
    }

    protected AbstractSerializer(Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        this.fieldDescriptor = fieldDescriptor;
        this.bMessage = bMessage;
        this.messageName = fieldDescriptor.getMessageType().getName();
        this.bFieldName = StringUtils.fromString((String)fieldDescriptor.getName());
        this.output = null;
    }

    public boolean isBMap() {
        return this.bMessage.getContent() instanceof BMap;
    }

    public boolean isBArray() {
        return this.bMessage.getContent() instanceof BArray;
    }

    protected int getIntValue(Object value) {
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return (Integer)value;
    }

    protected int getSize() {
        return this.bMessage.getSize();
    }
}

