/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;

public class EnumSerializer
extends AbstractSerializer {
    public EnumSerializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        BMap bMap;
        if (this.isBMap() && (bMap = (BMap)this.bMessage.getContent()).containsKey((Object)this.bFieldName)) {
            Object bValue = bMap.get((Object)this.bFieldName);
            this.bMessage.incrementSize(this.computeMessageSize(((BString)bValue).getValue()));
        }
    }

    @Override
    public void serialize() throws IOException {
        BMap bMap;
        if (this.isBMap() && (bMap = (BMap)this.bMessage.getContent()).containsKey((Object)this.bFieldName)) {
            Object bValue = bMap.get((Object)this.bFieldName);
            this.writeContent(((BString)bValue).getValue());
        }
    }

    private int computeMessageSize(String value) {
        return CodedOutputStream.computeEnumSize((int)this.fieldDescriptor.getNumber(), (int)this.fieldDescriptor.getEnumType().findValueByName(value).getNumber());
    }

    private void writeContent(String content) throws IOException {
        this.output.writeEnum(this.fieldDescriptor.getNumber(), this.fieldDescriptor.getEnumType().findValueByName(content).getNumber());
    }
}

