/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;

public class Int64Serializer
extends AbstractSerializer {
    public Int64Serializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.bMessage.incrementSize(this.computeMessageSize(valueArray.getInt((long)i)));
                    }
                } else {
                    this.bMessage.incrementSize(this.computeMessageSize((Long)bValue));
                }
            }
        } else if (this.bMessage.getContent() instanceof Long) {
            this.bMessage.incrementSize(this.computeMessageSize((Long)this.bMessage.getContent()));
        } else if (this.fieldDescriptor.getFullName().equals("google.protobuf.Timestamp.seconds") && this.isBArray()) {
            BArray array = (BArray)this.bMessage.getContent();
            this.bMessage.incrementSize(this.computeMessageSize(array.getInt(0L)));
        } else if (this.bMessage.getContent() instanceof BDecimal && this.fieldDescriptor.getFullName().equals("google.protobuf.Duration.seconds")) {
            this.bMessage.incrementSize(this.computeMessageSize(((BDecimal)this.bMessage.getContent()).value().intValue()));
        }
    }

    @Override
    public void serialize() throws IOException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.writeContent(valueArray.getInt((long)i));
                    }
                } else {
                    this.writeContent((Long)bValue);
                }
            }
        } else if (this.isBArray() && this.fieldDescriptor.getFullName().equals("google.protobuf.Timestamp.seconds")) {
            BArray bArray = (BArray)this.bMessage.getContent();
            this.writeContent((Long)bArray.get(0L));
        } else if (this.bMessage.getContent() instanceof BDecimal && this.fieldDescriptor.getFullName().equals("google.protobuf.Duration.seconds")) {
            this.writeContent(((BDecimal)this.bMessage.getContent()).value().intValue());
        } else if (this.bMessage.getContent() instanceof Long) {
            this.writeContent((Long)this.bMessage.getContent());
        }
    }

    private int computeMessageSize(long value) {
        return CodedOutputStream.computeInt64Size((int)this.fieldDescriptor.getNumber(), (long)value);
    }

    private void writeContent(long content) throws IOException {
        this.output.writeInt64(this.fieldDescriptor.getNumber(), content);
    }
}

