/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.BooleanSerializer;
import io.ballerina.stdlib.protobuf.serializers.BytesSerializer;
import io.ballerina.stdlib.protobuf.serializers.DoubleSerializer;
import io.ballerina.stdlib.protobuf.serializers.EnumSerializer;
import io.ballerina.stdlib.protobuf.serializers.Fixed32Serializer;
import io.ballerina.stdlib.protobuf.serializers.Fixed64Serializer;
import io.ballerina.stdlib.protobuf.serializers.FloatSerializer;
import io.ballerina.stdlib.protobuf.serializers.Int32Serializer;
import io.ballerina.stdlib.protobuf.serializers.Int64Serializer;
import io.ballerina.stdlib.protobuf.serializers.MessageSerializer;
import io.ballerina.stdlib.protobuf.serializers.StringSerializer;
import io.ballerina.stdlib.protobuf.serializers.UInt32Serializer;
import io.ballerina.stdlib.protobuf.serializers.UInt64Serializer;
import io.ballerina.stdlib.protobuf.utils.Utils;
import java.io.IOException;

public class SerializeHandler {
    private final Descriptors.Descriptor messageDescriptor;
    private CodedOutputStream outputStream;
    private final BMessage bMessage;
    private final int size;
    private final byte[] content;

    public SerializeHandler(Descriptors.Descriptor messageDescriptor, Object value) throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        this.messageDescriptor = messageDescriptor;
        this.bMessage = new BMessage(value);
        this.size = this.calculateSize();
        this.content = new byte[this.size];
        this.outputStream = CodedOutputStream.newInstance((byte[])this.content);
    }

    public SerializeHandler(CodedOutputStream outputStream, Descriptors.Descriptor messageDescriptor, Object value) throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        this.messageDescriptor = messageDescriptor;
        this.bMessage = new BMessage(value);
        this.size = this.calculateSize();
        this.content = new byte[0];
        this.outputStream = outputStream;
    }

    public Object getBMessage() {
        return this.bMessage.getContent();
    }

    public int getSize() {
        return this.bMessage.getSize();
    }

    public void serialize() throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        for (Descriptors.FieldDescriptor fieldDescriptor : this.messageDescriptor.getFields()) {
            switch (fieldDescriptor.getType().toProto().getNumber()) {
                case 1: {
                    new DoubleSerializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 2: {
                    new FloatSerializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 3: {
                    new Int64Serializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 4: {
                    new UInt64Serializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 5: {
                    new Int32Serializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 13: {
                    new UInt32Serializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 6: {
                    new Fixed64Serializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 7: {
                    new Fixed32Serializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 8: {
                    new BooleanSerializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 9: {
                    new StringSerializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 11: {
                    new MessageSerializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 14: {
                    new EnumSerializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
                case 12: {
                    new BytesSerializer(this.outputStream, fieldDescriptor, this.bMessage).serialize();
                    break;
                }
            }
        }
    }

    public int calculateSize() throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        for (Descriptors.FieldDescriptor fieldDescriptor : this.messageDescriptor.getFields()) {
            switch (fieldDescriptor.getType().toProto().getNumber()) {
                case 1: {
                    new DoubleSerializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 2: {
                    new FloatSerializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 3: {
                    new Int64Serializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 4: {
                    new UInt64Serializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 5: {
                    new Int32Serializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 13: {
                    new UInt32Serializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 6: {
                    new Fixed64Serializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 7: {
                    new Fixed32Serializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 8: {
                    new BooleanSerializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 9: {
                    new StringSerializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 11: {
                    new MessageSerializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 14: {
                    new EnumSerializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
                case 12: {
                    new BytesSerializer(this.outputStream, fieldDescriptor, this.bMessage).computeMessageSize();
                    break;
                }
            }
        }
        return this.bMessage.getSize();
    }

    public BString getContentAsBString() {
        return StringUtils.fromString((String)Utils.bytesToHex(this.content));
    }
}

