/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;

public class UInt32Serializer
extends AbstractSerializer {
    public UInt32Serializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.bMessage.incrementSize(this.computeMessageSize(Long.valueOf(valueArray.getInt((long)i)).intValue()));
                    }
                } else {
                    this.bMessage.incrementSize(this.computeMessageSize(((Long)bValue).intValue()));
                }
            }
        } else if (this.bMessage.getContent() instanceof Long) {
            this.bMessage.incrementSize(this.computeMessageSize(((Long)this.bMessage.getContent()).intValue()));
        }
    }

    @Override
    public void serialize() throws IOException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.writeContent(Long.valueOf(valueArray.getInt((long)i)).intValue());
                    }
                } else {
                    this.writeContent(((Long)bValue).intValue());
                }
            }
        } else if (this.bMessage.getContent() instanceof Long) {
            this.writeContent(((Long)this.bMessage.getContent()).intValue());
        }
    }

    private int computeMessageSize(int value) {
        return CodedOutputStream.computeUInt32Size((int)this.fieldDescriptor.getNumber(), (int)value);
    }

    private void writeContent(int content) throws IOException {
        this.output.writeUInt32(this.fieldDescriptor.getNumber(), content);
    }
}

