/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.utils;

import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.deserializers.DeserializeHandler;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.protobuf.utils.DescriptorBuilder;
import java.io.IOException;
import java.util.Arrays;

public class Utils {
    private Utils() {
    }

    public static String bytesToHex(byte[] content) {
        char[] hexChars = new char[content.length * 2];
        for (int j = 0; j < content.length; ++j) {
            int v = content[j] & 0xFF;
            hexChars[j * 2] = "0123456789ABCDEF".toCharArray()[v >>> 4];
            hexChars[j * 2 + 1] = "0123456789ABCDEF".toCharArray()[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexToBytes(String content) {
        if (content == null) {
            return new byte[0];
        }
        int len = content.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(content.charAt(i), 16) << 4) + Character.digit(content.charAt(i + 1), 16));
        }
        return data;
    }

    public static String getMessageNameFromTypeUrl(String typeUrl) {
        String[] literals = typeUrl.split("\\.");
        return literals[literals.length - 1];
    }

    public static Object deserialize(Type targetType, RecordType recordType, String content) throws Descriptors.DescriptorValidationException, IOException, AnnotationUnavailableException {
        if (Utils.isDescriptorAnnotationAvailable(recordType)) {
            String annotation = Utils.getProtobufDescAnnotation(recordType);
            DeserializeHandler m2 = new DeserializeHandler(annotation, content, targetType, (Type)recordType);
            m2.deserialize();
            return m2.getBMessage();
        }
        throw new AnnotationUnavailableException("Unavailable annotation for record " + recordType.getName());
    }

    public static boolean isDescriptorAnnotationAvailable(RecordType recordType) {
        return Arrays.stream((BString[])recordType.getAnnotations().getKeys()).anyMatch(s -> Utils.isValidProtoAnnotation(s.getValue()));
    }

    public static Descriptors.Descriptor getAnnotatedDescriptorFromRecord(Object value) throws Descriptors.DescriptorValidationException, InvalidProtocolBufferException, AnnotationUnavailableException {
        if (value instanceof BMap) {
            BMap bMap = (BMap)value;
            RecordType recordType = (RecordType)bMap.getType();
            return DescriptorBuilder.getDescriptorFromRecord(recordType);
        }
        throw new AnnotationUnavailableException("Expected annotation unavailable " + value.toString());
    }

    public static String getProtobufDescAnnotation(RecordType recordType) {
        BMap annotations = recordType.getAnnotations();
        return Utils.filterDescAnnotation((BMap<BString, Object>)annotations);
    }

    public static boolean isMatchingType(String typeUrl, int typeTag) {
        if (ModuleUtils.getAnyTypeMap().containsKey(typeUrl)) {
            return ModuleUtils.getAnyTypeMap().get(typeUrl) == typeTag;
        }
        return false;
    }

    public static String filterDescAnnotation(BMap<BString, Object> annotations) {
        for (BString annotationName : (BString[])annotations.getKeys()) {
            if (!Utils.isValidProtoAnnotation(annotationName.getValue())) continue;
            return annotations.getMapValue(annotationName).getStringValue(StringUtils.fromString((String)"value")).getValue();
        }
        return "";
    }

    public static boolean isValidProtoAnnotation(String annotationName) {
        return annotationName.contains("ballerina") && annotationName.contains("protobuf") && annotationName.contains("Descriptor");
    }
}

