/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractLexer;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;
import java.util.List;

public class BallerinaLexer
extends AbstractLexer {
    public BallerinaLexer(CharReader charReader) {
        super(charReader, ParserMode.DEFAULT);
    }

    @Override
    public STToken nextToken() {
        STToken token = switch (this.mode) {
            case ParserMode.TEMPLATE -> this.readTemplateToken();
            case ParserMode.REGEXP -> this.readRegExpTemplateToken();
            case ParserMode.INTERPOLATION -> {
                this.processLeadingTrivia();
                yield this.readTokenInInterpolation();
            }
            case ParserMode.INTERPOLATION_BRACED_CONTENT -> {
                this.processLeadingTrivia();
                yield this.readTokenInBracedContentInInterpolation();
            }
            default -> {
                this.processLeadingTrivia();
                yield this.readToken();
            }
        };
        return this.cloneWithDiagnostics(token);
    }

    private STToken readToken() {
        STToken token;
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char c = this.reader.peek();
        if (c == '\\') {
            this.processUnquotedIdentifier();
            return this.getIdentifierToken();
        }
        this.reader.advance();
        switch (c) {
            case ':': {
                token = this.getSyntaxToken(SyntaxKind.COLON_TOKEN);
                break;
            }
            case ';': {
                token = this.getSyntaxToken(SyntaxKind.SEMICOLON_TOKEN);
                break;
            }
            case '.': {
                token = this.processDot();
                break;
            }
            case ',': {
                token = this.getSyntaxToken(SyntaxKind.COMMA_TOKEN);
                break;
            }
            case '(': {
                token = this.getSyntaxToken(SyntaxKind.OPEN_PAREN_TOKEN);
                break;
            }
            case ')': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_PAREN_TOKEN);
                break;
            }
            case '{': {
                if (this.peek() == 124) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.OPEN_BRACE_TOKEN);
                break;
            }
            case '}': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_BRACE_TOKEN);
                break;
            }
            case '[': {
                token = this.getSyntaxToken(SyntaxKind.OPEN_BRACKET_TOKEN);
                break;
            }
            case ']': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_BRACKET_TOKEN);
                break;
            }
            case '|': {
                token = this.processPipeOperator();
                break;
            }
            case '?': {
                if (this.peek() == 46 && this.reader.peek(1) != '.') {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.OPTIONAL_CHAINING_TOKEN);
                    break;
                }
                if (this.peek() == 58) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.ELVIS_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.QUESTION_MARK_TOKEN);
                break;
            }
            case '\"': {
                token = this.processStringLiteral();
                break;
            }
            case '#': {
                token = this.processDocumentationString();
                break;
            }
            case '@': {
                token = this.getSyntaxToken(SyntaxKind.AT_TOKEN);
                break;
            }
            case '=': {
                token = this.processEqualOperator();
                break;
            }
            case '+': {
                token = this.getSyntaxToken(SyntaxKind.PLUS_TOKEN);
                break;
            }
            case '-': {
                if (this.reader.peek() == '>') {
                    this.reader.advance();
                    if (this.peek() == 62) {
                        this.reader.advance();
                        token = this.getSyntaxToken(SyntaxKind.SYNC_SEND_TOKEN);
                        break;
                    }
                    token = this.getSyntaxToken(SyntaxKind.RIGHT_ARROW_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.MINUS_TOKEN);
                break;
            }
            case '*': {
                token = this.getSyntaxToken(SyntaxKind.ASTERISK_TOKEN);
                break;
            }
            case '/': {
                token = this.processSlashToken();
                break;
            }
            case '%': {
                token = this.getSyntaxToken(SyntaxKind.PERCENT_TOKEN);
                break;
            }
            case '<': {
                token = this.processTokenStartWithLt();
                break;
            }
            case '>': {
                token = this.processTokenStartWithGt();
                break;
            }
            case '!': {
                token = this.processExclamationMarkOperator();
                break;
            }
            case '&': {
                if (this.peek() == 38) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.LOGICAL_AND_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.BITWISE_AND_TOKEN);
                break;
            }
            case '^': {
                token = this.getSyntaxToken(SyntaxKind.BITWISE_XOR_TOKEN);
                break;
            }
            case '~': {
                token = this.getSyntaxToken(SyntaxKind.NEGATION_TOKEN);
                break;
            }
            case '`': {
                this.startMode(ParserMode.TEMPLATE);
                token = this.getBacktickToken();
                break;
            }
            case '\'': {
                token = this.processQuotedIdentifier();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                token = this.processNumericLiteral(c);
                break;
            }
            default: {
                if (BallerinaLexer.isIdentifierInitialChar(c)) {
                    token = this.processIdentifierOrKeyword();
                    break;
                }
                STToken invalidToken = this.processInvalidToken();
                token = this.nextToken();
                token = SyntaxErrors.addDiagnostic(token, DiagnosticErrorCode.ERROR_INVALID_TOKEN, invalidToken);
            }
        }
        return token;
    }

    private STToken getSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getIdentifierToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createIdentifierToken(lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getLiteral(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private void processLeadingTrivia() {
        this.processSyntaxTrivia(this.leadingTriviaList, true);
    }

    private STNode processTrailingTrivia() {
        ArrayList<STNode> triviaList = new ArrayList<STNode>(10);
        this.processSyntaxTrivia(triviaList, false);
        return STNodeFactory.createNodeList(triviaList);
    }

    private void processSyntaxTrivia(List<STNode> triviaList, boolean isLeading) {
        while (!this.reader.isEOF()) {
            this.reader.mark();
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    triviaList.add(this.processWhitespaces());
                    break;
                }
                case '\n': 
                case '\r': {
                    triviaList.add(this.processEndOfLine());
                    if (isLeading) break;
                    return;
                }
                case '/': {
                    if (this.reader.peek(1) == '/') {
                        triviaList.add(this.processComment());
                        break;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private STNode processWhitespaces() {
        block4: while (!this.reader.isEOF()) {
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    this.reader.advance();
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
    }

    private STNode processEndOfLine() {
        char c = this.reader.peek();
        switch (c) {
            case '\n': {
                this.reader.advance();
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
            case '\r': {
                this.reader.advance();
                if (this.reader.peek() == '\n') {
                    this.reader.advance();
                }
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
        }
        throw new IllegalStateException();
    }

    private STToken processDot() {
        char nextChar = this.reader.peek();
        if (nextChar == '.') {
            char nextNextChar = this.reader.peek(1);
            if (nextNextChar == '.') {
                this.reader.advance(2);
                return this.getSyntaxToken(SyntaxKind.ELLIPSIS_TOKEN);
            }
            if (nextNextChar == '<') {
                this.reader.advance(2);
                return this.getSyntaxToken(SyntaxKind.DOUBLE_DOT_LT_TOKEN);
            }
        } else {
            if (nextChar == '@') {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.ANNOT_CHAINING_TOKEN);
            }
            if (nextChar == '<') {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.DOT_LT_TOKEN);
            }
        }
        if (this.mode != ParserMode.IMPORT && BallerinaLexer.isDigit(nextChar)) {
            return this.processDecimalFloatLiteral();
        }
        return this.getSyntaxToken(SyntaxKind.DOT_TOKEN);
    }

    private STNode processComment() {
        this.reader.advance(2);
        int nextToken = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextToken) {
                case 10: 
                case 13: {
                    break block3;
                }
                default: {
                    this.reader.advance();
                    nextToken = this.peek();
                    continue block3;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.COMMENT_MINUTIAE, this.getLexeme());
    }

    private STToken processEqualOperator() {
        switch (this.peek()) {
            case 61: {
                this.reader.advance();
                if (this.peek() == 61) {
                    this.reader.advance();
                    return this.getSyntaxToken(SyntaxKind.TRIPPLE_EQUAL_TOKEN);
                }
                return this.getSyntaxToken(SyntaxKind.DOUBLE_EQUAL_TOKEN);
            }
            case 62: {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN);
            }
        }
        return this.getSyntaxToken(SyntaxKind.EQUAL_TOKEN);
    }

    private STToken processNumericLiteral(int startChar) {
        int nextChar = this.peek();
        if (this.isHexIndicator(startChar, nextChar)) {
            return this.processHexLiteral();
        }
        int len = 1;
        block3: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 46: 
                case 68: 
                case 69: 
                case 70: 
                case 100: 
                case 101: 
                case 102: {
                    char nextNextChar = this.reader.peek(1);
                    if (nextChar == 46 && (nextNextChar == '.' || this.isDecimalNumberFollowedIdentifier()) || this.mode == ParserMode.IMPORT) break block3;
                    if (startChar == 48 && len > 1) {
                        this.reportLexerError(DiagnosticErrorCode.ERROR_LEADING_ZEROS_IN_NUMERIC_LITERALS, new Object[0]);
                    }
                    return this.processDecimalFloatLiteral();
                }
                default: {
                    if (!BallerinaLexer.isDigit(nextChar)) break block3;
                    this.reader.advance();
                    ++len;
                    nextChar = this.peek();
                    continue block3;
                }
            }
        }
        if (startChar == 48 && len > 1) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_LEADING_ZEROS_IN_NUMERIC_LITERALS, new Object[0]);
        }
        return this.getLiteral(SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN);
    }

    private STToken processDecimalFloatLiteral() {
        int nextChar = this.peek();
        if (nextChar == 46) {
            this.reader.advance();
            nextChar = this.peek();
            if (!BallerinaLexer.isDigit(nextChar)) {
                this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_DIGIT_AFTER_DOT, new Object[0]);
            }
        }
        while (BallerinaLexer.isDigit(nextChar)) {
            this.reader.advance();
            nextChar = this.peek();
        }
        return switch (nextChar) {
            case 69, 101 -> this.processExponent(false);
            case 68, 70, 100, 102 -> this.parseFloatingPointTypeSuffix();
            default -> this.getLiteral(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN);
        };
    }

    private STToken processExponent(boolean isHex) {
        this.reader.advance();
        int nextChar = this.peek();
        if (nextChar == 43 || nextChar == 45) {
            this.reader.advance();
            nextChar = this.peek();
        }
        if (!BallerinaLexer.isDigit(nextChar)) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_DIGIT_AFTER_EXPONENT_INDICATOR, new Object[0]);
        }
        while (BallerinaLexer.isDigit(nextChar)) {
            this.reader.advance();
            nextChar = this.peek();
        }
        if (isHex) {
            return this.getLiteral(SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN);
        }
        return switch (nextChar) {
            case 68, 70, 100, 102 -> this.parseFloatingPointTypeSuffix();
            default -> this.getLiteral(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN);
        };
    }

    private STToken parseFloatingPointTypeSuffix() {
        this.reader.advance();
        return this.getLiteral(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN);
    }

    private STToken processHexLiteral() {
        this.reader.advance();
        boolean containsHexDigit = false;
        while (BallerinaLexer.isHexDigit(this.peek())) {
            this.reader.advance();
            containsHexDigit = true;
        }
        int nextChar = this.peek();
        switch (nextChar) {
            case 46: {
                if (this.isHexIntFollowedIdentifier()) {
                    return this.getHexIntegerLiteral();
                }
                this.reader.advance();
                if (!BallerinaLexer.isHexDigit(this.reader.peek())) {
                    this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_HEX_DIGIT_AFTER_DOT, new Object[0]);
                }
                nextChar = this.peek();
                while (BallerinaLexer.isHexDigit(nextChar)) {
                    this.reader.advance();
                    nextChar = this.peek();
                }
                switch (nextChar) {
                    case 80: 
                    case 112: {
                        return this.processExponent(true);
                    }
                }
                break;
            }
            case 80: 
            case 112: {
                if (!containsHexDigit) {
                    this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_HEX_NUMBER_AFTER_HEX_INDICATOR, new Object[0]);
                }
                return this.processExponent(true);
            }
            default: {
                return this.getHexIntegerLiteral();
            }
        }
        return this.getLiteral(SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN);
    }

    private STToken getHexIntegerLiteral() {
        String lexeme = this.getLexeme();
        if ("0x".equals(lexeme) || "0X".equals(lexeme)) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_HEX_NUMBER_AFTER_HEX_INDICATOR, new Object[0]);
        }
        return this.getLiteral(SyntaxKind.HEX_INTEGER_LITERAL_TOKEN);
    }

    private boolean isDecimalNumberFollowedIdentifier() {
        int lookahead = 1;
        char lookaheadChar = this.reader.peek(lookahead);
        if (BallerinaLexer.isDigit(lookaheadChar)) {
            return false;
        }
        switch (lookaheadChar) {
            case 'E': 
            case 'e': {
                lookaheadChar = this.reader.peek(++lookahead);
                if (lookaheadChar == '+' || lookaheadChar == '-') {
                    return false;
                }
                lookaheadChar = this.reader.peek(lookahead);
                while (BallerinaLexer.isDigit(lookaheadChar)) {
                    lookaheadChar = this.reader.peek(++lookahead);
                }
                if (lookaheadChar != 'd' && lookaheadChar != 'D' && lookaheadChar != 'f' && lookaheadChar != 'F') break;
                ++lookahead;
                break;
            }
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                ++lookahead;
                break;
            }
        }
        lookaheadChar = this.reader.peek(lookahead);
        return BallerinaLexer.isIdentifierFollowingChar(lookaheadChar);
    }

    private boolean isHexIntFollowedIdentifier() {
        int lookahead = 1;
        char lookaheadChar = this.reader.peek(lookahead);
        if (BallerinaLexer.isDigit(lookaheadChar)) {
            return false;
        }
        while (BallerinaLexer.isHexDigit(lookaheadChar)) {
            lookaheadChar = this.reader.peek(++lookahead);
        }
        switch (lookaheadChar) {
            case 'P': 
            case 'p': {
                lookaheadChar = this.reader.peek(++lookahead);
                if (lookaheadChar == '+' || lookaheadChar == '-') {
                    return false;
                }
                lookaheadChar = this.reader.peek(lookahead);
                while (BallerinaLexer.isDigit(lookaheadChar)) {
                    lookaheadChar = this.reader.peek(++lookahead);
                }
                break;
            }
        }
        return BallerinaLexer.isIdentifierFollowingChar(lookaheadChar);
    }

    private STToken processIdentifierOrKeyword() {
        String tokenText;
        this.processUnquotedIdentifier();
        return switch (tokenText = this.getLexeme()) {
            case "int" -> this.getSyntaxToken(SyntaxKind.INT_KEYWORD);
            case "float" -> this.getSyntaxToken(SyntaxKind.FLOAT_KEYWORD);
            case "string" -> this.getSyntaxToken(SyntaxKind.STRING_KEYWORD);
            case "boolean" -> this.getSyntaxToken(SyntaxKind.BOOLEAN_KEYWORD);
            case "decimal" -> this.getSyntaxToken(SyntaxKind.DECIMAL_KEYWORD);
            case "xml" -> this.getSyntaxToken(SyntaxKind.XML_KEYWORD);
            case "json" -> this.getSyntaxToken(SyntaxKind.JSON_KEYWORD);
            case "handle" -> this.getSyntaxToken(SyntaxKind.HANDLE_KEYWORD);
            case "any" -> this.getSyntaxToken(SyntaxKind.ANY_KEYWORD);
            case "anydata" -> this.getSyntaxToken(SyntaxKind.ANYDATA_KEYWORD);
            case "never" -> this.getSyntaxToken(SyntaxKind.NEVER_KEYWORD);
            case "byte" -> this.getSyntaxToken(SyntaxKind.BYTE_KEYWORD);
            case "public" -> this.getSyntaxToken(SyntaxKind.PUBLIC_KEYWORD);
            case "private" -> this.getSyntaxToken(SyntaxKind.PRIVATE_KEYWORD);
            case "function" -> this.getSyntaxToken(SyntaxKind.FUNCTION_KEYWORD);
            case "return" -> this.getSyntaxToken(SyntaxKind.RETURN_KEYWORD);
            case "returns" -> this.getSyntaxToken(SyntaxKind.RETURNS_KEYWORD);
            case "external" -> this.getSyntaxToken(SyntaxKind.EXTERNAL_KEYWORD);
            case "type" -> this.getSyntaxToken(SyntaxKind.TYPE_KEYWORD);
            case "record" -> this.getSyntaxToken(SyntaxKind.RECORD_KEYWORD);
            case "object" -> this.getSyntaxToken(SyntaxKind.OBJECT_KEYWORD);
            case "remote" -> this.getSyntaxToken(SyntaxKind.REMOTE_KEYWORD);
            case "abstract" -> this.getSyntaxToken(SyntaxKind.ABSTRACT_KEYWORD);
            case "client" -> this.getSyntaxToken(SyntaxKind.CLIENT_KEYWORD);
            case "if" -> this.getSyntaxToken(SyntaxKind.IF_KEYWORD);
            case "else" -> this.getSyntaxToken(SyntaxKind.ELSE_KEYWORD);
            case "while" -> this.getSyntaxToken(SyntaxKind.WHILE_KEYWORD);
            case "true" -> this.getSyntaxToken(SyntaxKind.TRUE_KEYWORD);
            case "false" -> this.getSyntaxToken(SyntaxKind.FALSE_KEYWORD);
            case "check" -> this.getSyntaxToken(SyntaxKind.CHECK_KEYWORD);
            case "fail" -> this.getSyntaxToken(SyntaxKind.FAIL_KEYWORD);
            case "checkpanic" -> this.getSyntaxToken(SyntaxKind.CHECKPANIC_KEYWORD);
            case "continue" -> this.getSyntaxToken(SyntaxKind.CONTINUE_KEYWORD);
            case "break" -> this.getSyntaxToken(SyntaxKind.BREAK_KEYWORD);
            case "panic" -> this.getSyntaxToken(SyntaxKind.PANIC_KEYWORD);
            case "import" -> this.getSyntaxToken(SyntaxKind.IMPORT_KEYWORD);
            case "as" -> this.getSyntaxToken(SyntaxKind.AS_KEYWORD);
            case "service" -> this.getSyntaxToken(SyntaxKind.SERVICE_KEYWORD);
            case "on" -> this.getSyntaxToken(SyntaxKind.ON_KEYWORD);
            case "resource" -> this.getSyntaxToken(SyntaxKind.RESOURCE_KEYWORD);
            case "listener" -> this.getSyntaxToken(SyntaxKind.LISTENER_KEYWORD);
            case "const" -> this.getSyntaxToken(SyntaxKind.CONST_KEYWORD);
            case "final" -> this.getSyntaxToken(SyntaxKind.FINAL_KEYWORD);
            case "typeof" -> this.getSyntaxToken(SyntaxKind.TYPEOF_KEYWORD);
            case "is" -> this.getSyntaxToken(SyntaxKind.IS_KEYWORD);
            case "null" -> this.getSyntaxToken(SyntaxKind.NULL_KEYWORD);
            case "lock" -> this.getSyntaxToken(SyntaxKind.LOCK_KEYWORD);
            case "annotation" -> this.getSyntaxToken(SyntaxKind.ANNOTATION_KEYWORD);
            case "source" -> this.getSyntaxToken(SyntaxKind.SOURCE_KEYWORD);
            case "var" -> this.getSyntaxToken(SyntaxKind.VAR_KEYWORD);
            case "worker" -> this.getSyntaxToken(SyntaxKind.WORKER_KEYWORD);
            case "parameter" -> this.getSyntaxToken(SyntaxKind.PARAMETER_KEYWORD);
            case "field" -> this.getSyntaxToken(SyntaxKind.FIELD_KEYWORD);
            case "isolated" -> this.getSyntaxToken(SyntaxKind.ISOLATED_KEYWORD);
            case "xmlns" -> this.getSyntaxToken(SyntaxKind.XMLNS_KEYWORD);
            case "fork" -> this.getSyntaxToken(SyntaxKind.FORK_KEYWORD);
            case "map" -> this.getSyntaxToken(SyntaxKind.MAP_KEYWORD);
            case "future" -> this.getSyntaxToken(SyntaxKind.FUTURE_KEYWORD);
            case "typedesc" -> this.getSyntaxToken(SyntaxKind.TYPEDESC_KEYWORD);
            case "trap" -> this.getSyntaxToken(SyntaxKind.TRAP_KEYWORD);
            case "in" -> this.getSyntaxToken(SyntaxKind.IN_KEYWORD);
            case "foreach" -> this.getSyntaxToken(SyntaxKind.FOREACH_KEYWORD);
            case "table" -> this.getSyntaxToken(SyntaxKind.TABLE_KEYWORD);
            case "error" -> this.getSyntaxToken(SyntaxKind.ERROR_KEYWORD);
            case "let" -> this.getSyntaxToken(SyntaxKind.LET_KEYWORD);
            case "stream" -> this.getSyntaxToken(SyntaxKind.STREAM_KEYWORD);
            case "new" -> this.getSyntaxToken(SyntaxKind.NEW_KEYWORD);
            case "readonly" -> this.getSyntaxToken(SyntaxKind.READONLY_KEYWORD);
            case "distinct" -> this.getSyntaxToken(SyntaxKind.DISTINCT_KEYWORD);
            case "from" -> this.getSyntaxToken(SyntaxKind.FROM_KEYWORD);
            case "start" -> this.getSyntaxToken(SyntaxKind.START_KEYWORD);
            case "flush" -> this.getSyntaxToken(SyntaxKind.FLUSH_KEYWORD);
            case "wait" -> this.getSyntaxToken(SyntaxKind.WAIT_KEYWORD);
            case "do" -> this.getSyntaxToken(SyntaxKind.DO_KEYWORD);
            case "transaction" -> this.getSyntaxToken(SyntaxKind.TRANSACTION_KEYWORD);
            case "commit" -> this.getSyntaxToken(SyntaxKind.COMMIT_KEYWORD);
            case "retry" -> this.getSyntaxToken(SyntaxKind.RETRY_KEYWORD);
            case "rollback" -> this.getSyntaxToken(SyntaxKind.ROLLBACK_KEYWORD);
            case "transactional" -> this.getSyntaxToken(SyntaxKind.TRANSACTIONAL_KEYWORD);
            case "enum" -> this.getSyntaxToken(SyntaxKind.ENUM_KEYWORD);
            case "base16" -> this.getSyntaxToken(SyntaxKind.BASE16_KEYWORD);
            case "base64" -> this.getSyntaxToken(SyntaxKind.BASE64_KEYWORD);
            case "match" -> this.getSyntaxToken(SyntaxKind.MATCH_KEYWORD);
            case "conflict" -> this.getSyntaxToken(SyntaxKind.CONFLICT_KEYWORD);
            case "class" -> this.getSyntaxToken(SyntaxKind.CLASS_KEYWORD);
            case "configurable" -> this.getSyntaxToken(SyntaxKind.CONFIGURABLE_KEYWORD);
            case "where" -> this.getSyntaxToken(SyntaxKind.WHERE_KEYWORD);
            case "select" -> this.getSyntaxToken(SyntaxKind.SELECT_KEYWORD);
            case "limit" -> this.getSyntaxToken(SyntaxKind.LIMIT_KEYWORD);
            case "outer" -> this.getSyntaxToken(SyntaxKind.OUTER_KEYWORD);
            case "equals" -> this.getSyntaxToken(SyntaxKind.EQUALS_KEYWORD);
            case "order" -> this.getSyntaxToken(SyntaxKind.ORDER_KEYWORD);
            case "by" -> this.getSyntaxToken(SyntaxKind.BY_KEYWORD);
            case "ascending" -> this.getSyntaxToken(SyntaxKind.ASCENDING_KEYWORD);
            case "descending" -> this.getSyntaxToken(SyntaxKind.DESCENDING_KEYWORD);
            case "join" -> this.getSyntaxToken(SyntaxKind.JOIN_KEYWORD);
            case "re" -> {
                if (this.getNextNonWSOrNonCommentChar() == 96) {
                    yield this.getSyntaxToken(SyntaxKind.RE_KEYWORD);
                }
                yield this.getIdentifierToken();
            }
            default -> this.getIdentifierToken();
        };
    }

    private int getNextNonWSOrNonCommentChar() {
        int lookaheadCount = 0;
        char nextChar = this.reader.peek(lookaheadCount);
        while (nextChar != '\uffff') {
            switch (nextChar) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++lookaheadCount;
                    break;
                }
                case '/': {
                    if (this.reader.peek(lookaheadCount + 1) == '/') {
                        lookaheadCount += 2;
                        lookaheadCount = this.skipComment(lookaheadCount);
                        break;
                    }
                    return nextChar;
                }
                default: {
                    return nextChar;
                }
            }
            nextChar = this.reader.peek(lookaheadCount);
        }
        return nextChar;
    }

    private int skipComment(int lookaheadCount) {
        char nextChar = this.reader.peek(lookaheadCount);
        block3: while (nextChar != '\uffff') {
            switch (nextChar) {
                case '\n': 
                case '\r': {
                    break block3;
                }
                default: {
                    nextChar = this.reader.peek(++lookaheadCount);
                    continue block3;
                }
            }
        }
        return lookaheadCount;
    }

    private STToken processInvalidToken() {
        while (!this.isEndOfInvalidToken()) {
            this.reader.advance();
        }
        String tokenText = this.getLexeme();
        STToken invalidToken = STNodeFactory.createInvalidToken(tokenText);
        STNode invalidNodeMinutiae = STNodeFactory.createInvalidNodeMinutiae(invalidToken);
        this.leadingTriviaList.add(invalidNodeMinutiae);
        return invalidToken;
    }

    private boolean isEndOfInvalidToken() {
        if (this.reader.isEOF()) {
            return true;
        }
        int currentChar = this.peek();
        return switch (currentChar) {
            case 9, 10, 13, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 96, 123, 124, 125, 126 -> true;
            default -> BallerinaLexer.isIdentifierFollowingChar(currentChar);
        };
    }

    private boolean isHexIndicator(int startChar, int nextChar) {
        return startChar == 48 && (nextChar == 120 || nextChar == 88);
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    private STToken processStringLiteral() {
        block9: while (!this.reader.isEOF()) {
            int nextChar = this.peek();
            switch (nextChar) {
                case 10: 
                case 13: {
                    this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_DOUBLE_QUOTE, new Object[0]);
                    break block9;
                }
                case 34: {
                    this.reader.advance();
                    break block9;
                }
                case 92: {
                    switch (this.reader.peek(1)) {
                        case '\"': 
                        case '\\': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            this.reader.advance(2);
                            continue block9;
                        }
                        case 'u': {
                            if (this.reader.peek(2) == '{') {
                                this.processNumericEscape();
                                continue block9;
                            }
                            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
                            this.reader.advance(2);
                            continue block9;
                        }
                    }
                    this.reportInvalidEscapeSequence(this.reader.peek(1));
                    this.reader.advance();
                    continue block9;
                }
                default: {
                    this.reader.advance();
                    continue block9;
                }
            }
        }
        return this.getLiteral(SyntaxKind.STRING_LITERAL_TOKEN);
    }

    private STToken processExclamationMarkOperator() {
        switch (this.peek()) {
            case 61: {
                this.reader.advance();
                if (this.peek() == 61) {
                    this.reader.advance();
                    return this.getSyntaxToken(SyntaxKind.NOT_DOUBLE_EQUAL_TOKEN);
                }
                return this.getSyntaxToken(SyntaxKind.NOT_EQUAL_TOKEN);
            }
        }
        if (this.isNotIsToken()) {
            this.reader.advance(2);
            return this.getSyntaxToken(SyntaxKind.NOT_IS_KEYWORD);
        }
        return this.getSyntaxToken(SyntaxKind.EXCLAMATION_MARK_TOKEN);
    }

    private boolean isNotIsToken() {
        return this.reader.peek() == 'i' && this.reader.peek(1) == 's' && !BallerinaLexer.isIdentifierFollowingChar(this.reader.peek(2)) && this.reader.peek(2) != '\\';
    }

    private STToken processPipeOperator() {
        return switch (this.peek()) {
            case 125 -> {
                this.reader.advance();
                yield this.getSyntaxToken(SyntaxKind.CLOSE_BRACE_PIPE_TOKEN);
            }
            case 124 -> {
                this.reader.advance();
                yield this.getSyntaxToken(SyntaxKind.LOGICAL_OR_TOKEN);
            }
            default -> this.getSyntaxToken(SyntaxKind.PIPE_TOKEN);
        };
    }

    private STToken processSlashToken() {
        if (this.peek() != 42) {
            return this.getSyntaxToken(SyntaxKind.SLASH_TOKEN);
        }
        this.reader.advance();
        if (this.peek() != 42) {
            return this.getSyntaxToken(SyntaxKind.SLASH_ASTERISK_TOKEN);
        }
        if (this.reader.peek(1) == '/' && this.reader.peek(2) == '<') {
            this.reader.advance(3);
            return this.getSyntaxToken(SyntaxKind.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN);
        }
        return this.getSyntaxToken(SyntaxKind.SLASH_ASTERISK_TOKEN);
    }

    private STToken processDocumentationString() {
        int nextChar = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 10: 
                case 13: {
                    if (this.peek() == 13 && this.reader.peek(1) == '\n') {
                        this.reader.advance();
                    }
                    this.reader.advance();
                    int lookAheadCount = 0;
                    char lookAheadChar = this.reader.peek(lookAheadCount);
                    while (lookAheadChar == ' ' || lookAheadChar == '\t') {
                        lookAheadChar = this.reader.peek(++lookAheadCount);
                    }
                    if (lookAheadChar != '#') break block3;
                    this.reader.advance(lookAheadCount);
                    nextChar = this.peek();
                    continue block3;
                }
                default: {
                    this.reader.advance();
                    nextChar = this.peek();
                    continue block3;
                }
            }
        }
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = STNodeFactory.createNodeList(new ArrayList<STNode>(0));
        return STNodeFactory.createLiteralValueToken(SyntaxKind.DOCUMENTATION_STRING, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getBacktickToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STNodeFactory.createEmptyNodeList();
        return STNodeFactory.createToken(SyntaxKind.BACKTICK_TOKEN, leadingTrivia, trailingTrivia);
    }

    private STToken readTemplateToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        switch (nextChar) {
            case '`': {
                this.reader.advance();
                this.endMode();
                return this.getSyntaxToken(SyntaxKind.BACKTICK_TOKEN);
            }
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.startMode(ParserMode.INTERPOLATION);
                this.reader.advance(2);
                return this.getSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
        }
        block8: while (!this.reader.isEOF()) {
            this.reader.advance();
            nextChar = this.reader.peek();
            switch (nextChar) {
                case '$': {
                    if (this.reader.peek(1) != '{') continue block8;
                    break block8;
                }
                case '`': {
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return this.getLiteral(SyntaxKind.TEMPLATE_STRING);
    }

    private STToken readRegExpTemplateToken() {
        boolean shouldProcessInterpolations = true;
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        switch (nextChar) {
            case '`': {
                this.reader.advance();
                this.endMode();
                return this.getSyntaxToken(SyntaxKind.BACKTICK_TOKEN);
            }
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.startMode(ParserMode.INTERPOLATION);
                this.reader.advance(2);
                return this.getSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
        }
        if (nextChar == '[') {
            shouldProcessInterpolations = false;
        }
        block11: while (!this.reader.isEOF()) {
            if (shouldProcessInterpolations && this.reader.peek() == '\\' && this.reader.peek(1) == '[') {
                this.reader.advance();
            }
            this.reader.advance();
            nextChar = this.reader.peek();
            switch (nextChar) {
                case '$': {
                    if (!shouldProcessInterpolations || this.reader.peek(1) != '{') continue block11;
                    break block11;
                }
                case '`': {
                    break block11;
                }
                case '[': {
                    shouldProcessInterpolations = false;
                    continue block11;
                }
                case ']': {
                    shouldProcessInterpolations = true;
                    continue block11;
                }
                case '\\': {
                    if (shouldProcessInterpolations || this.reader.peek(1) != ']') continue block11;
                    this.reader.advance();
                    continue block11;
                }
                default: {
                    continue block11;
                }
            }
        }
        return this.getLiteral(SyntaxKind.TEMPLATE_STRING);
    }

    private STToken processQuotedIdentifier() {
        this.processIdentifierEnd();
        if (String.valueOf('\'').equals(this.getLexeme())) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INCOMPLETE_QUOTED_IDENTIFIER, new Object[0]);
        }
        return this.getIdentifierToken();
    }

    private void processUnquotedIdentifier() {
        this.processIdentifierEnd();
    }

    private void processIdentifierEnd() {
        block4: while (!this.reader.isEOF()) {
            char nextChar = this.reader.peek();
            if (BallerinaLexer.isIdentifierFollowingChar(nextChar)) {
                this.reader.advance();
                continue;
            }
            if (nextChar != '\\') break;
            nextChar = this.reader.peek(1);
            switch (nextChar) {
                case '\t': 
                case '\n': 
                case '\r': {
                    this.reader.advance();
                    this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, "");
                    break block4;
                }
                case 'u': {
                    if (this.reader.peek(2) == '{') {
                        this.processNumericEscape();
                        continue block4;
                    }
                    this.reader.advance(2);
                    continue block4;
                }
                default: {
                    if (!this.isValidQuotedIdentifierEscapeChar(nextChar)) {
                        this.reportInvalidEscapeSequence(nextChar);
                    }
                    this.reader.advance(2);
                    continue block4;
                }
            }
        }
    }

    private void reportInvalidEscapeSequence(char nextChar) {
        String escapeSequence = String.valueOf(nextChar);
        this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, escapeSequence);
    }

    private boolean isValidQuotedIdentifierEscapeChar(int nextChar) {
        if (65 <= nextChar && nextChar <= 90) {
            return false;
        }
        if (97 <= nextChar && nextChar <= 122) {
            return false;
        }
        return !BallerinaLexer.isUnicodePatternWhiteSpaceChar(nextChar);
    }

    private STToken processTokenStartWithLt() {
        int nextChar = this.peek();
        switch (nextChar) {
            case 61: {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.LT_EQUAL_TOKEN);
            }
            case 45: {
                char nextNextChar = this.reader.peek(1);
                if (BallerinaLexer.isDigit(nextNextChar)) {
                    return this.getSyntaxToken(SyntaxKind.LT_TOKEN);
                }
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.LEFT_ARROW_TOKEN);
            }
            case 60: {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.DOUBLE_LT_TOKEN);
            }
        }
        return this.getSyntaxToken(SyntaxKind.LT_TOKEN);
    }

    private STToken processTokenStartWithGt() {
        if (this.peek() == 61) {
            this.reader.advance();
            return this.getSyntaxToken(SyntaxKind.GT_EQUAL_TOKEN);
        }
        if (this.reader.peek() != '>') {
            return this.getSyntaxToken(SyntaxKind.GT_TOKEN);
        }
        char nextChar = this.reader.peek(1);
        return switch (nextChar) {
            case '>' -> {
                if (this.reader.peek(2) == '=') {
                    this.reader.advance(2);
                    yield this.getSyntaxToken(SyntaxKind.TRIPPLE_GT_TOKEN);
                }
                yield this.getSyntaxToken(SyntaxKind.GT_TOKEN);
            }
            case '=' -> {
                this.reader.advance(1);
                yield this.getSyntaxToken(SyntaxKind.DOUBLE_GT_TOKEN);
            }
            default -> this.getSyntaxToken(SyntaxKind.GT_TOKEN);
        };
    }

    private STToken readTokenInInterpolation() {
        this.reader.mark();
        int nextChar = this.peek();
        switch (nextChar) {
            case 123: {
                this.startMode(ParserMode.INTERPOLATION_BRACED_CONTENT);
                return this.readToken();
            }
            case 125: {
                this.endMode();
                this.reader.advance();
                return this.getSyntaxTokenWithoutTrailingTrivia(SyntaxKind.CLOSE_BRACE_TOKEN);
            }
        }
        return this.readToken();
    }

    private STToken getSyntaxTokenWithoutTrailingTrivia(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STNodeFactory.createNodeList(new ArrayList<STNode>(0));
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken readTokenInBracedContentInInterpolation() {
        this.reader.mark();
        int nextChar = this.peek();
        switch (nextChar) {
            case 123: {
                this.startMode(ParserMode.INTERPOLATION_BRACED_CONTENT);
                break;
            }
            case 125: {
                this.endMode();
                break;
            }
            case 96: {
                while (this.mode != ParserMode.DEFAULT) {
                    this.endMode();
                }
                this.reader.advance();
                return this.getBacktickToken();
            }
        }
        return this.readToken();
    }
}

