/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STArrayTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode memberTypeDesc;
    public final STNode dimensions;

    STArrayTypeDescriptorNode(STNode memberTypeDesc, STNode dimensions) {
        this(memberTypeDesc, dimensions, Collections.emptyList());
    }

    STArrayTypeDescriptorNode(STNode memberTypeDesc, STNode dimensions, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ARRAY_TYPE_DESC, diagnostics);
        this.memberTypeDesc = memberTypeDesc;
        this.dimensions = dimensions;
        this.addChildren(memberTypeDesc, dimensions);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STArrayTypeDescriptorNode(this.memberTypeDesc, this.dimensions, diagnostics);
    }

    public STArrayTypeDescriptorNode modify(STNode memberTypeDesc, STNode dimensions) {
        if (this.checkForReferenceEquality(memberTypeDesc, dimensions)) {
            return this;
        }
        return new STArrayTypeDescriptorNode(memberTypeDesc, dimensions, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ArrayTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

