/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STAssignmentStatementNode
extends STStatementNode {
    public final STNode varRef;
    public final STNode equalsToken;
    public final STNode expression;
    public final STNode semicolonToken;

    STAssignmentStatementNode(STNode varRef, STNode equalsToken, STNode expression, STNode semicolonToken) {
        this(varRef, equalsToken, expression, semicolonToken, Collections.emptyList());
    }

    STAssignmentStatementNode(STNode varRef, STNode equalsToken, STNode expression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ASSIGNMENT_STATEMENT, diagnostics);
        this.varRef = varRef;
        this.equalsToken = equalsToken;
        this.expression = expression;
        this.semicolonToken = semicolonToken;
        this.addChildren(varRef, equalsToken, expression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STAssignmentStatementNode(this.varRef, this.equalsToken, this.expression, this.semicolonToken, diagnostics);
    }

    public STAssignmentStatementNode modify(STNode varRef, STNode equalsToken, STNode expression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(varRef, equalsToken, expression, semicolonToken)) {
            return this;
        }
        return new STAssignmentStatementNode(varRef, equalsToken, expression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new AssignmentStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

