/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STFunctionBodyNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STExpressionFunctionBodyNode
extends STFunctionBodyNode {
    public final STNode rightDoubleArrow;
    public final STNode expression;
    public final STNode semicolon;

    STExpressionFunctionBodyNode(STNode rightDoubleArrow, STNode expression, STNode semicolon) {
        this(rightDoubleArrow, expression, semicolon, Collections.emptyList());
    }

    STExpressionFunctionBodyNode(STNode rightDoubleArrow, STNode expression, STNode semicolon, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.EXPRESSION_FUNCTION_BODY, diagnostics);
        this.rightDoubleArrow = rightDoubleArrow;
        this.expression = expression;
        this.semicolon = semicolon;
        this.addChildren(rightDoubleArrow, expression, semicolon);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STExpressionFunctionBodyNode(this.rightDoubleArrow, this.expression, this.semicolon, diagnostics);
    }

    public STExpressionFunctionBodyNode modify(STNode rightDoubleArrow, STNode expression, STNode semicolon) {
        if (this.checkForReferenceEquality(rightDoubleArrow, expression, semicolon)) {
            return this;
        }
        return new STExpressionFunctionBodyNode(rightDoubleArrow, expression, semicolon, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ExpressionFunctionBodyNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

