/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STIndexedExpressionNode
extends STTypeDescriptorNode {
    public final STNode containerExpression;
    public final STNode openBracket;
    public final STNode keyExpression;
    public final STNode closeBracket;

    STIndexedExpressionNode(STNode containerExpression, STNode openBracket, STNode keyExpression, STNode closeBracket) {
        this(containerExpression, openBracket, keyExpression, closeBracket, Collections.emptyList());
    }

    STIndexedExpressionNode(STNode containerExpression, STNode openBracket, STNode keyExpression, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.INDEXED_EXPRESSION, diagnostics);
        this.containerExpression = containerExpression;
        this.openBracket = openBracket;
        this.keyExpression = keyExpression;
        this.closeBracket = closeBracket;
        this.addChildren(containerExpression, openBracket, keyExpression, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STIndexedExpressionNode(this.containerExpression, this.openBracket, this.keyExpression, this.closeBracket, diagnostics);
    }

    public STIndexedExpressionNode modify(STNode containerExpression, STNode openBracket, STNode keyExpression, STNode closeBracket) {
        if (this.checkForReferenceEquality(containerExpression, openBracket, keyExpression, closeBracket)) {
            return this;
        }
        return new STIndexedExpressionNode(containerExpression, openBracket, keyExpression, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new IndexedExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

