/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STDocumentationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.InlineCodeReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STInlineCodeReferenceNode
extends STDocumentationNode {
    public final STNode startBacktick;
    public final STNode codeReference;
    public final STNode endBacktick;

    STInlineCodeReferenceNode(STNode startBacktick, STNode codeReference, STNode endBacktick) {
        this(startBacktick, codeReference, endBacktick, Collections.emptyList());
    }

    STInlineCodeReferenceNode(STNode startBacktick, STNode codeReference, STNode endBacktick, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.INLINE_CODE_REFERENCE, diagnostics);
        this.startBacktick = startBacktick;
        this.codeReference = codeReference;
        this.endBacktick = endBacktick;
        this.addChildren(startBacktick, codeReference, endBacktick);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STInlineCodeReferenceNode(this.startBacktick, this.codeReference, this.endBacktick, diagnostics);
    }

    public STInlineCodeReferenceNode modify(STNode startBacktick, STNode codeReference, STNode endBacktick) {
        if (this.checkForReferenceEquality(startBacktick, codeReference, endBacktick)) {
            return this;
        }
        return new STInlineCodeReferenceNode(startBacktick, codeReference, endBacktick, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new InlineCodeReferenceNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

