/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STKeySpecifierNode
extends STNode {
    public final STNode keyKeyword;
    public final STNode openParenToken;
    public final STNode fieldNames;
    public final STNode closeParenToken;

    STKeySpecifierNode(STNode keyKeyword, STNode openParenToken, STNode fieldNames, STNode closeParenToken) {
        this(keyKeyword, openParenToken, fieldNames, closeParenToken, Collections.emptyList());
    }

    STKeySpecifierNode(STNode keyKeyword, STNode openParenToken, STNode fieldNames, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.KEY_SPECIFIER, diagnostics);
        this.keyKeyword = keyKeyword;
        this.openParenToken = openParenToken;
        this.fieldNames = fieldNames;
        this.closeParenToken = closeParenToken;
        this.addChildren(keyKeyword, openParenToken, fieldNames, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STKeySpecifierNode(this.keyKeyword, this.openParenToken, this.fieldNames, this.closeParenToken, diagnostics);
    }

    public STKeySpecifierNode modify(STNode keyKeyword, STNode openParenToken, STNode fieldNames, STNode closeParenToken) {
        if (this.checkForReferenceEquality(keyKeyword, openParenToken, fieldNames, closeParenToken)) {
            return this;
        }
        return new STKeySpecifierNode(keyKeyword, openParenToken, fieldNames, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new KeySpecifierNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

