/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.KeyTypeConstraintNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STKeyTypeConstraintNode
extends STNode {
    public final STNode keyKeywordToken;
    public final STNode typeParameterNode;

    STKeyTypeConstraintNode(STNode keyKeywordToken, STNode typeParameterNode) {
        this(keyKeywordToken, typeParameterNode, Collections.emptyList());
    }

    STKeyTypeConstraintNode(STNode keyKeywordToken, STNode typeParameterNode, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.KEY_TYPE_CONSTRAINT, diagnostics);
        this.keyKeywordToken = keyKeywordToken;
        this.typeParameterNode = typeParameterNode;
        this.addChildren(keyKeywordToken, typeParameterNode);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STKeyTypeConstraintNode(this.keyKeywordToken, this.typeParameterNode, diagnostics);
    }

    public STKeyTypeConstraintNode modify(STNode keyKeywordToken, STNode typeParameterNode) {
        if (this.checkForReferenceEquality(keyKeywordToken, typeParameterNode)) {
            return this;
        }
        return new STKeyTypeConstraintNode(keyKeywordToken, typeParameterNode, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new KeyTypeConstraintNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

