/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STLetExpressionNode
extends STExpressionNode {
    public final STNode letKeyword;
    public final STNode letVarDeclarations;
    public final STNode inKeyword;
    public final STNode expression;

    STLetExpressionNode(STNode letKeyword, STNode letVarDeclarations, STNode inKeyword, STNode expression) {
        this(letKeyword, letVarDeclarations, inKeyword, expression, Collections.emptyList());
    }

    STLetExpressionNode(STNode letKeyword, STNode letVarDeclarations, STNode inKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LET_EXPRESSION, diagnostics);
        this.letKeyword = letKeyword;
        this.letVarDeclarations = letVarDeclarations;
        this.inKeyword = inKeyword;
        this.expression = expression;
        this.addChildren(letKeyword, letVarDeclarations, inKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STLetExpressionNode(this.letKeyword, this.letVarDeclarations, this.inKeyword, this.expression, diagnostics);
    }

    public STLetExpressionNode modify(STNode letKeyword, STNode letVarDeclarations, STNode inKeyword, STNode expression) {
        if (this.checkForReferenceEquality(letKeyword, letVarDeclarations, inKeyword, expression)) {
            return this;
        }
        return new STLetExpressionNode(letKeyword, letVarDeclarations, inKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new LetExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

