/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnConflictClauseNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STOnConflictClauseNode
extends STClauseNode {
    public final STNode onKeyword;
    public final STNode conflictKeyword;
    public final STNode expression;

    STOnConflictClauseNode(STNode onKeyword, STNode conflictKeyword, STNode expression) {
        this(onKeyword, conflictKeyword, expression, Collections.emptyList());
    }

    STOnConflictClauseNode(STNode onKeyword, STNode conflictKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ON_CONFLICT_CLAUSE, diagnostics);
        this.onKeyword = onKeyword;
        this.conflictKeyword = conflictKeyword;
        this.expression = expression;
        this.addChildren(onKeyword, conflictKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STOnConflictClauseNode(this.onKeyword, this.conflictKeyword, this.expression, diagnostics);
    }

    public STOnConflictClauseNode modify(STNode onKeyword, STNode conflictKeyword, STNode expression) {
        if (this.checkForReferenceEquality(onKeyword, conflictKeyword, expression)) {
            return this;
        }
        return new STOnConflictClauseNode(onKeyword, conflictKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new OnConflictClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

