/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReBracedQuantifierNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReBracedQuantifierNode
extends STNode {
    public final STNode openBraceToken;
    public final STNode leastTimesMatchedDigit;
    public final STNode commaToken;
    public final STNode mostTimesMatchedDigit;
    public final STNode closeBraceToken;

    STReBracedQuantifierNode(STNode openBraceToken, STNode leastTimesMatchedDigit, STNode commaToken, STNode mostTimesMatchedDigit, STNode closeBraceToken) {
        this(openBraceToken, leastTimesMatchedDigit, commaToken, mostTimesMatchedDigit, closeBraceToken, Collections.emptyList());
    }

    STReBracedQuantifierNode(STNode openBraceToken, STNode leastTimesMatchedDigit, STNode commaToken, STNode mostTimesMatchedDigit, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RE_BRACED_QUANTIFIER, diagnostics);
        this.openBraceToken = openBraceToken;
        this.leastTimesMatchedDigit = leastTimesMatchedDigit;
        this.commaToken = commaToken;
        this.mostTimesMatchedDigit = mostTimesMatchedDigit;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(openBraceToken, leastTimesMatchedDigit, commaToken, mostTimesMatchedDigit, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReBracedQuantifierNode(this.openBraceToken, this.leastTimesMatchedDigit, this.commaToken, this.mostTimesMatchedDigit, this.closeBraceToken, diagnostics);
    }

    public STReBracedQuantifierNode modify(STNode openBraceToken, STNode leastTimesMatchedDigit, STNode commaToken, STNode mostTimesMatchedDigit, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, leastTimesMatchedDigit, commaToken, mostTimesMatchedDigit, closeBraceToken)) {
            return this;
        }
        return new STReBracedQuantifierNode(openBraceToken, leastTimesMatchedDigit, commaToken, mostTimesMatchedDigit, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReBracedQuantifierNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

