/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReCharacterClassNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReCharacterClassNode
extends STNode {
    public final STNode openBracket;
    public final STNode negation;
    public final STNode reCharSet;
    public final STNode closeBracket;

    STReCharacterClassNode(STNode openBracket, STNode negation, STNode reCharSet, STNode closeBracket) {
        this(openBracket, negation, reCharSet, closeBracket, Collections.emptyList());
    }

    STReCharacterClassNode(STNode openBracket, STNode negation, STNode reCharSet, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RE_CHARACTER_CLASS, diagnostics);
        this.openBracket = openBracket;
        this.negation = negation;
        this.reCharSet = reCharSet;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, negation, reCharSet, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReCharacterClassNode(this.openBracket, this.negation, this.reCharSet, this.closeBracket, diagnostics);
    }

    public STReCharacterClassNode modify(STNode openBracket, STNode negation, STNode reCharSet, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, negation, reCharSet, closeBracket)) {
            return this;
        }
        return new STReCharacterClassNode(openBracket, negation, reCharSet, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReCharacterClassNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

