/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRecordTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode recordKeyword;
    public final STNode bodyStartDelimiter;
    public final STNode fields;
    public final STNode recordRestDescriptor;
    public final STNode bodyEndDelimiter;

    STRecordTypeDescriptorNode(STNode recordKeyword, STNode bodyStartDelimiter, STNode fields, STNode recordRestDescriptor, STNode bodyEndDelimiter) {
        this(recordKeyword, bodyStartDelimiter, fields, recordRestDescriptor, bodyEndDelimiter, Collections.emptyList());
    }

    STRecordTypeDescriptorNode(STNode recordKeyword, STNode bodyStartDelimiter, STNode fields, STNode recordRestDescriptor, STNode bodyEndDelimiter, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RECORD_TYPE_DESC, diagnostics);
        this.recordKeyword = recordKeyword;
        this.bodyStartDelimiter = bodyStartDelimiter;
        this.fields = fields;
        this.recordRestDescriptor = recordRestDescriptor;
        this.bodyEndDelimiter = bodyEndDelimiter;
        this.addChildren(recordKeyword, bodyStartDelimiter, fields, recordRestDescriptor, bodyEndDelimiter);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRecordTypeDescriptorNode(this.recordKeyword, this.bodyStartDelimiter, this.fields, this.recordRestDescriptor, this.bodyEndDelimiter, diagnostics);
    }

    public STRecordTypeDescriptorNode modify(STNode recordKeyword, STNode bodyStartDelimiter, STNode fields, STNode recordRestDescriptor, STNode bodyEndDelimiter) {
        if (this.checkForReferenceEquality(recordKeyword, bodyStartDelimiter, fields, recordRestDescriptor, bodyEndDelimiter)) {
            return this;
        }
        return new STRecordTypeDescriptorNode(recordKeyword, bodyStartDelimiter, fields, recordRestDescriptor, bodyEndDelimiter, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RecordTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

