/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STActionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRemoteMethodCallActionNode
extends STActionNode {
    public final STNode expression;
    public final STNode rightArrowToken;
    public final STNode methodName;
    public final STNode openParenToken;
    public final STNode arguments;
    public final STNode closeParenToken;

    STRemoteMethodCallActionNode(STNode expression, STNode rightArrowToken, STNode methodName, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        this(expression, rightArrowToken, methodName, openParenToken, arguments, closeParenToken, Collections.emptyList());
    }

    STRemoteMethodCallActionNode(STNode expression, STNode rightArrowToken, STNode methodName, STNode openParenToken, STNode arguments, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.REMOTE_METHOD_CALL_ACTION, diagnostics);
        this.expression = expression;
        this.rightArrowToken = rightArrowToken;
        this.methodName = methodName;
        this.openParenToken = openParenToken;
        this.arguments = arguments;
        this.closeParenToken = closeParenToken;
        this.addChildren(expression, rightArrowToken, methodName, openParenToken, arguments, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRemoteMethodCallActionNode(this.expression, this.rightArrowToken, this.methodName, this.openParenToken, this.arguments, this.closeParenToken, diagnostics);
    }

    public STRemoteMethodCallActionNode modify(STNode expression, STNode rightArrowToken, STNode methodName, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        if (this.checkForReferenceEquality(expression, rightArrowToken, methodName, openParenToken, arguments, closeParenToken)) {
            return this;
        }
        return new STRemoteMethodCallActionNode(expression, rightArrowToken, methodName, openParenToken, arguments, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RemoteMethodCallActionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

