/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RestDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRestDescriptorNode
extends STNode {
    public final STNode typeDescriptor;
    public final STNode ellipsisToken;

    STRestDescriptorNode(STNode typeDescriptor, STNode ellipsisToken) {
        this(typeDescriptor, ellipsisToken, Collections.emptyList());
    }

    STRestDescriptorNode(STNode typeDescriptor, STNode ellipsisToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.REST_TYPE, diagnostics);
        this.typeDescriptor = typeDescriptor;
        this.ellipsisToken = ellipsisToken;
        this.addChildren(typeDescriptor, ellipsisToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRestDescriptorNode(this.typeDescriptor, this.ellipsisToken, diagnostics);
    }

    public STRestDescriptorNode modify(STNode typeDescriptor, STNode ellipsisToken) {
        if (this.checkForReferenceEquality(typeDescriptor, ellipsisToken)) {
            return this;
        }
        return new STRestDescriptorNode(typeDescriptor, ellipsisToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RestDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

