/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRetryStatementNode
extends STStatementNode {
    public final STNode retryKeyword;
    public final STNode typeParameter;
    public final STNode arguments;
    public final STNode retryBody;
    public final STNode onFailClause;

    STRetryStatementNode(STNode retryKeyword, STNode typeParameter, STNode arguments, STNode retryBody, STNode onFailClause) {
        this(retryKeyword, typeParameter, arguments, retryBody, onFailClause, Collections.emptyList());
    }

    STRetryStatementNode(STNode retryKeyword, STNode typeParameter, STNode arguments, STNode retryBody, STNode onFailClause, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RETRY_STATEMENT, diagnostics);
        this.retryKeyword = retryKeyword;
        this.typeParameter = typeParameter;
        this.arguments = arguments;
        this.retryBody = retryBody;
        this.onFailClause = onFailClause;
        this.addChildren(retryKeyword, typeParameter, arguments, retryBody, onFailClause);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRetryStatementNode(this.retryKeyword, this.typeParameter, this.arguments, this.retryBody, this.onFailClause, diagnostics);
    }

    public STRetryStatementNode modify(STNode retryKeyword, STNode typeParameter, STNode arguments, STNode retryBody, STNode onFailClause) {
        if (this.checkForReferenceEquality(retryKeyword, typeParameter, arguments, retryBody, onFailClause)) {
            return this;
        }
        return new STRetryStatementNode(retryKeyword, typeParameter, arguments, retryBody, onFailClause, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RetryStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

