/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STTrapExpressionNode
extends STExpressionNode {
    public final STNode trapKeyword;
    public final STNode expression;

    STTrapExpressionNode(SyntaxKind kind, STNode trapKeyword, STNode expression) {
        this(kind, trapKeyword, expression, Collections.emptyList());
    }

    STTrapExpressionNode(SyntaxKind kind, STNode trapKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(kind, diagnostics);
        this.trapKeyword = trapKeyword;
        this.expression = expression;
        this.addChildren(trapKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTrapExpressionNode(this.kind, this.trapKeyword, this.expression, diagnostics);
    }

    public STTrapExpressionNode modify(SyntaxKind kind, STNode trapKeyword, STNode expression) {
        if (this.checkForReferenceEquality(trapKeyword, expression)) {
            return this;
        }
        return new STTrapExpressionNode(kind, trapKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TrapExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

