/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import java.util.Collection;
import java.util.Collections;

public class STTypeReferenceNode
extends STTypeDescriptorNode {
    public final STNode asteriskToken;
    public final STNode typeName;
    public final STNode semicolonToken;

    STTypeReferenceNode(STNode asteriskToken, STNode typeName, STNode semicolonToken) {
        this(asteriskToken, typeName, semicolonToken, Collections.emptyList());
    }

    STTypeReferenceNode(STNode asteriskToken, STNode typeName, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPE_REFERENCE, diagnostics);
        this.asteriskToken = asteriskToken;
        this.typeName = typeName;
        this.semicolonToken = semicolonToken;
        this.addChildren(asteriskToken, typeName, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypeReferenceNode(this.asteriskToken, this.typeName, this.semicolonToken, diagnostics);
    }

    public STTypeReferenceNode modify(STNode asteriskToken, STNode typeName, STNode semicolonToken) {
        if (this.checkForReferenceEquality(asteriskToken, typeName, semicolonToken)) {
            return this;
        }
        return new STTypeReferenceNode(asteriskToken, typeName, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypeReferenceNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

