/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Collection;
import java.util.Collections;

public class STTypedBindingPatternNode
extends STNode {
    public final STNode typeDescriptor;
    public final STNode bindingPattern;

    STTypedBindingPatternNode(STNode typeDescriptor, STNode bindingPattern) {
        this(typeDescriptor, bindingPattern, Collections.emptyList());
    }

    STTypedBindingPatternNode(STNode typeDescriptor, STNode bindingPattern, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPED_BINDING_PATTERN, diagnostics);
        this.typeDescriptor = typeDescriptor;
        this.bindingPattern = bindingPattern;
        this.addChildren(typeDescriptor, bindingPattern);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypedBindingPatternNode(this.typeDescriptor, this.bindingPattern, diagnostics);
    }

    public STTypedBindingPatternNode modify(STNode typeDescriptor, STNode bindingPattern) {
        if (this.checkForReferenceEquality(typeDescriptor, bindingPattern)) {
            return this;
        }
        return new STTypedBindingPatternNode(typeDescriptor, bindingPattern, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypedBindingPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

