/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import java.util.Collection;
import java.util.Collections;

public class STUnionTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode leftTypeDesc;
    public final STNode pipeToken;
    public final STNode rightTypeDesc;

    STUnionTypeDescriptorNode(STNode leftTypeDesc, STNode pipeToken, STNode rightTypeDesc) {
        this(leftTypeDesc, pipeToken, rightTypeDesc, Collections.emptyList());
    }

    STUnionTypeDescriptorNode(STNode leftTypeDesc, STNode pipeToken, STNode rightTypeDesc, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.UNION_TYPE_DESC, diagnostics);
        this.leftTypeDesc = leftTypeDesc;
        this.pipeToken = pipeToken;
        this.rightTypeDesc = rightTypeDesc;
        this.addChildren(leftTypeDesc, pipeToken, rightTypeDesc);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STUnionTypeDescriptorNode(this.leftTypeDesc, this.pipeToken, this.rightTypeDesc, diagnostics);
    }

    public STUnionTypeDescriptorNode modify(STNode leftTypeDesc, STNode pipeToken, STNode rightTypeDesc) {
        if (this.checkForReferenceEquality(leftTypeDesc, pipeToken, rightTypeDesc)) {
            return this;
        }
        return new STUnionTypeDescriptorNode(leftTypeDesc, pipeToken, rightTypeDesc, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new UnionTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

