/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLItemNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLElementNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLElementNode
extends STXMLItemNode {
    public final STNode startTag;
    public final STNode content;
    public final STNode endTag;

    STXMLElementNode(STNode startTag, STNode content, STNode endTag) {
        this(startTag, content, endTag, Collections.emptyList());
    }

    STXMLElementNode(STNode startTag, STNode content, STNode endTag, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_ELEMENT, diagnostics);
        this.startTag = startTag;
        this.content = content;
        this.endTag = endTag;
        this.addChildren(startTag, content, endTag);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLElementNode(this.startTag, this.content, this.endTag, diagnostics);
    }

    public STXMLElementNode modify(STNode startTag, STNode content, STNode endTag) {
        if (this.checkForReferenceEquality(startTag, content, endTag)) {
            return this;
        }
        return new STXMLElementNode(startTag, content, endTag, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLElementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

