/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLNavigateExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLFilterExpressionNode
extends STXMLNavigateExpressionNode {
    public final STNode expression;
    public final STNode xmlPatternChain;

    STXMLFilterExpressionNode(STNode expression, STNode xmlPatternChain) {
        this(expression, xmlPatternChain, Collections.emptyList());
    }

    STXMLFilterExpressionNode(STNode expression, STNode xmlPatternChain, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_FILTER_EXPRESSION, diagnostics);
        this.expression = expression;
        this.xmlPatternChain = xmlPatternChain;
        this.addChildren(expression, xmlPatternChain);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLFilterExpressionNode(this.expression, this.xmlPatternChain, diagnostics);
    }

    public STXMLFilterExpressionNode modify(STNode expression, STNode xmlPatternChain) {
        if (this.checkForReferenceEquality(expression, xmlPatternChain)) {
            return this;
        }
        return new STXMLFilterExpressionNode(expression, xmlPatternChain, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLFilterExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

