/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLItemNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLProcessingInstruction;
import java.util.Collection;
import java.util.Collections;

public class STXMLProcessingInstruction
extends STXMLItemNode {
    public final STNode piStart;
    public final STNode target;
    public final STNode data;
    public final STNode piEnd;

    STXMLProcessingInstruction(STNode piStart, STNode target, STNode data, STNode piEnd) {
        this(piStart, target, data, piEnd, Collections.emptyList());
    }

    STXMLProcessingInstruction(STNode piStart, STNode target, STNode data, STNode piEnd, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_PI, diagnostics);
        this.piStart = piStart;
        this.target = target;
        this.data = data;
        this.piEnd = piEnd;
        this.addChildren(piStart, target, data, piEnd);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLProcessingInstruction(this.piStart, this.target, this.data, this.piEnd, diagnostics);
    }

    public STXMLProcessingInstruction modify(STNode piStart, STNode target, STNode data, STNode piEnd) {
        if (this.checkForReferenceEquality(piStart, target, data, piEnd)) {
            return this;
        }
        return new STXMLProcessingInstruction(piStart, target, data, piEnd, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLProcessingInstruction(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

