/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class AnnotationDeclarationNode
extends ModuleMemberDeclarationNode {
    public AnnotationDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> visibilityQualifier() {
        return this.optionalChildInBucket(1);
    }

    public Optional<Token> constKeyword() {
        return this.optionalChildInBucket(2);
    }

    public Token annotationKeyword() {
        return (Token)this.childInBucket(3);
    }

    public Optional<Node> typeDescriptor() {
        return this.optionalChildInBucket(4);
    }

    public Token annotationTag() {
        return (Token)this.childInBucket(5);
    }

    public Optional<Token> onKeyword() {
        return this.optionalChildInBucket(6);
    }

    public SeparatedNodeList<Node> attachPoints() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(7));
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(8);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "visibilityQualifier", "constKeyword", "annotationKeyword", "typeDescriptor", "annotationTag", "onKeyword", "attachPoints", "semicolonToken"};
    }

    public AnnotationDeclarationNode modify(MetadataNode metadata, Token visibilityQualifier, Token constKeyword, Token annotationKeyword, Node typeDescriptor, Token annotationTag, Token onKeyword, SeparatedNodeList<Node> attachPoints, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, constKeyword, annotationKeyword, typeDescriptor, annotationTag, onKeyword, attachPoints.underlyingListNode(), semicolonToken)) {
            return this;
        }
        return NodeFactory.createAnnotationDeclarationNode(metadata, visibilityQualifier, constKeyword, annotationKeyword, typeDescriptor, annotationTag, onKeyword, attachPoints, semicolonToken);
    }

    public AnnotationDeclarationNodeModifier modify() {
        return new AnnotationDeclarationNodeModifier(this);
    }

    public static class AnnotationDeclarationNodeModifier {
        private final AnnotationDeclarationNode oldNode;
        private MetadataNode metadata;
        private Token visibilityQualifier;
        private Token constKeyword;
        private Token annotationKeyword;
        private Node typeDescriptor;
        private Token annotationTag;
        private Token onKeyword;
        private SeparatedNodeList<Node> attachPoints;
        private Token semicolonToken;

        public AnnotationDeclarationNodeModifier(AnnotationDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.visibilityQualifier = oldNode.visibilityQualifier().orElse(null);
            this.constKeyword = oldNode.constKeyword().orElse(null);
            this.annotationKeyword = oldNode.annotationKeyword();
            this.typeDescriptor = oldNode.typeDescriptor().orElse(null);
            this.annotationTag = oldNode.annotationTag();
            this.onKeyword = oldNode.onKeyword().orElse(null);
            this.attachPoints = oldNode.attachPoints();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public AnnotationDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public AnnotationDeclarationNodeModifier withVisibilityQualifier(Token visibilityQualifier) {
            this.visibilityQualifier = visibilityQualifier;
            return this;
        }

        public AnnotationDeclarationNodeModifier withConstKeyword(Token constKeyword) {
            this.constKeyword = constKeyword;
            return this;
        }

        public AnnotationDeclarationNodeModifier withAnnotationKeyword(Token annotationKeyword) {
            Objects.requireNonNull(annotationKeyword, "annotationKeyword must not be null");
            this.annotationKeyword = annotationKeyword;
            return this;
        }

        public AnnotationDeclarationNodeModifier withTypeDescriptor(Node typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public AnnotationDeclarationNodeModifier withAnnotationTag(Token annotationTag) {
            Objects.requireNonNull(annotationTag, "annotationTag must not be null");
            this.annotationTag = annotationTag;
            return this;
        }

        public AnnotationDeclarationNodeModifier withOnKeyword(Token onKeyword) {
            this.onKeyword = onKeyword;
            return this;
        }

        public AnnotationDeclarationNodeModifier withAttachPoints(SeparatedNodeList<Node> attachPoints) {
            Objects.requireNonNull(attachPoints, "attachPoints must not be null");
            this.attachPoints = attachPoints;
            return this;
        }

        public AnnotationDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public AnnotationDeclarationNode apply() {
            return this.oldNode.modify(this.metadata, this.visibilityQualifier, this.constKeyword, this.annotationKeyword, this.typeDescriptor, this.annotationTag, this.onKeyword, this.attachPoints, this.semicolonToken);
        }
    }
}

