/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class ArrayTypeDescriptorNode
extends TypeDescriptorNode {
    public ArrayTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public TypeDescriptorNode memberTypeDesc() {
        return (TypeDescriptorNode)this.childInBucket(0);
    }

    public NodeList<ArrayDimensionNode> dimensions() {
        return new NodeList<ArrayDimensionNode>((NonTerminalNode)this.childInBucket(1));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"memberTypeDesc", "dimensions"};
    }

    public ArrayTypeDescriptorNode modify(TypeDescriptorNode memberTypeDesc, NodeList<ArrayDimensionNode> dimensions) {
        if (this.checkForReferenceEquality(memberTypeDesc, dimensions.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createArrayTypeDescriptorNode(memberTypeDesc, dimensions);
    }

    public ArrayTypeDescriptorNodeModifier modify() {
        return new ArrayTypeDescriptorNodeModifier(this);
    }

    public static class ArrayTypeDescriptorNodeModifier {
        private final ArrayTypeDescriptorNode oldNode;
        private TypeDescriptorNode memberTypeDesc;
        private NodeList<ArrayDimensionNode> dimensions;

        public ArrayTypeDescriptorNodeModifier(ArrayTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.memberTypeDesc = oldNode.memberTypeDesc();
            this.dimensions = oldNode.dimensions();
        }

        public ArrayTypeDescriptorNodeModifier withMemberTypeDesc(TypeDescriptorNode memberTypeDesc) {
            Objects.requireNonNull(memberTypeDesc, "memberTypeDesc must not be null");
            this.memberTypeDesc = memberTypeDesc;
            return this;
        }

        public ArrayTypeDescriptorNodeModifier withDimensions(NodeList<ArrayDimensionNode> dimensions) {
            Objects.requireNonNull(dimensions, "dimensions must not be null");
            this.dimensions = dimensions;
            return this;
        }

        public ArrayTypeDescriptorNode apply() {
            return this.oldNode.modify(this.memberTypeDesc, this.dimensions);
        }
    }
}

