/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class BracedExpressionNode
extends ExpressionNode {
    public BracedExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParen() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token closeParen() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParen", "expression", "closeParen"};
    }

    public BracedExpressionNode modify(SyntaxKind kind, Token openParen, ExpressionNode expression, Token closeParen) {
        if (this.checkForReferenceEquality(openParen, expression, closeParen)) {
            return this;
        }
        return NodeFactory.createBracedExpressionNode(kind, openParen, expression, closeParen);
    }

    public BracedExpressionNodeModifier modify() {
        return new BracedExpressionNodeModifier(this);
    }

    public static class BracedExpressionNodeModifier {
        private final BracedExpressionNode oldNode;
        private Token openParen;
        private ExpressionNode expression;
        private Token closeParen;

        public BracedExpressionNodeModifier(BracedExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.openParen = oldNode.openParen();
            this.expression = oldNode.expression();
            this.closeParen = oldNode.closeParen();
        }

        public BracedExpressionNodeModifier withOpenParen(Token openParen) {
            Objects.requireNonNull(openParen, "openParen must not be null");
            this.openParen = openParen;
            return this;
        }

        public BracedExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public BracedExpressionNodeModifier withCloseParen(Token closeParen) {
            Objects.requireNonNull(closeParen, "closeParen must not be null");
            this.closeParen = closeParen;
            return this;
        }

        public BracedExpressionNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.openParen, this.expression, this.closeParen);
        }
    }
}

