/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class CheckExpressionNode
extends ExpressionNode {
    public CheckExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token checkKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"checkKeyword", "expression"};
    }

    public CheckExpressionNode modify(SyntaxKind kind, Token checkKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(checkKeyword, expression)) {
            return this;
        }
        return NodeFactory.createCheckExpressionNode(kind, checkKeyword, expression);
    }

    public CheckExpressionNodeModifier modify() {
        return new CheckExpressionNodeModifier(this);
    }

    public static class CheckExpressionNodeModifier {
        private final CheckExpressionNode oldNode;
        private Token checkKeyword;
        private ExpressionNode expression;

        public CheckExpressionNodeModifier(CheckExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.checkKeyword = oldNode.checkKeyword();
            this.expression = oldNode.expression();
        }

        public CheckExpressionNodeModifier withCheckKeyword(Token checkKeyword) {
            Objects.requireNonNull(checkKeyword, "checkKeyword must not be null");
            this.checkKeyword = checkKeyword;
            return this;
        }

        public CheckExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public CheckExpressionNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.checkKeyword, this.expression);
        }
    }
}

