/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class DoubleGTTokenNode
extends NonTerminalNode {
    public DoubleGTTokenNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openGTToken() {
        return (Token)this.childInBucket(0);
    }

    public Token endGTToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openGTToken", "endGTToken"};
    }

    public DoubleGTTokenNode modify(Token openGTToken, Token endGTToken) {
        if (this.checkForReferenceEquality(openGTToken, endGTToken)) {
            return this;
        }
        return NodeFactory.createDoubleGTTokenNode(openGTToken, endGTToken);
    }

    public DoubleGTTokenNodeModifier modify() {
        return new DoubleGTTokenNodeModifier(this);
    }

    public static class DoubleGTTokenNodeModifier {
        private final DoubleGTTokenNode oldNode;
        private Token openGTToken;
        private Token endGTToken;

        public DoubleGTTokenNodeModifier(DoubleGTTokenNode oldNode) {
            this.oldNode = oldNode;
            this.openGTToken = oldNode.openGTToken();
            this.endGTToken = oldNode.endGTToken();
        }

        public DoubleGTTokenNodeModifier withOpenGTToken(Token openGTToken) {
            Objects.requireNonNull(openGTToken, "openGTToken must not be null");
            this.openGTToken = openGTToken;
            return this;
        }

        public DoubleGTTokenNodeModifier withEndGTToken(Token endGTToken) {
            Objects.requireNonNull(endGTToken, "endGTToken must not be null");
            this.endGTToken = endGTToken;
            return this;
        }

        public DoubleGTTokenNode apply() {
            return this.oldNode.modify(this.openGTToken, this.endGTToken);
        }
    }
}

