/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ElseBlockNode
extends NonTerminalNode {
    public ElseBlockNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token elseKeyword() {
        return (Token)this.childInBucket(0);
    }

    public StatementNode elseBody() {
        return (StatementNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"elseKeyword", "elseBody"};
    }

    public ElseBlockNode modify(Token elseKeyword, StatementNode elseBody) {
        if (this.checkForReferenceEquality(elseKeyword, elseBody)) {
            return this;
        }
        return NodeFactory.createElseBlockNode(elseKeyword, elseBody);
    }

    public ElseBlockNodeModifier modify() {
        return new ElseBlockNodeModifier(this);
    }

    public static class ElseBlockNodeModifier {
        private final ElseBlockNode oldNode;
        private Token elseKeyword;
        private StatementNode elseBody;

        public ElseBlockNodeModifier(ElseBlockNode oldNode) {
            this.oldNode = oldNode;
            this.elseKeyword = oldNode.elseKeyword();
            this.elseBody = oldNode.elseBody();
        }

        public ElseBlockNodeModifier withElseKeyword(Token elseKeyword) {
            Objects.requireNonNull(elseKeyword, "elseKeyword must not be null");
            this.elseKeyword = elseKeyword;
            return this;
        }

        public ElseBlockNodeModifier withElseBody(StatementNode elseBody) {
            Objects.requireNonNull(elseBody, "elseBody must not be null");
            this.elseBody = elseBody;
            return this;
        }

        public ElseBlockNode apply() {
            return this.oldNode.modify(this.elseKeyword, this.elseBody);
        }
    }
}

