/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class ExplicitNewExpressionNode
extends NewExpressionNode {
    public ExplicitNewExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token newKeyword() {
        return (Token)this.childInBucket(0);
    }

    public TypeDescriptorNode typeDescriptor() {
        return (TypeDescriptorNode)this.childInBucket(1);
    }

    public ParenthesizedArgList parenthesizedArgList() {
        return (ParenthesizedArgList)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"newKeyword", "typeDescriptor", "parenthesizedArgList"};
    }

    public ExplicitNewExpressionNode modify(Token newKeyword, TypeDescriptorNode typeDescriptor, ParenthesizedArgList parenthesizedArgList) {
        if (this.checkForReferenceEquality(newKeyword, typeDescriptor, parenthesizedArgList)) {
            return this;
        }
        return NodeFactory.createExplicitNewExpressionNode(newKeyword, typeDescriptor, parenthesizedArgList);
    }

    public ExplicitNewExpressionNodeModifier modify() {
        return new ExplicitNewExpressionNodeModifier(this);
    }

    public static class ExplicitNewExpressionNodeModifier {
        private final ExplicitNewExpressionNode oldNode;
        private Token newKeyword;
        private TypeDescriptorNode typeDescriptor;
        private ParenthesizedArgList parenthesizedArgList;

        public ExplicitNewExpressionNodeModifier(ExplicitNewExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.newKeyword = oldNode.newKeyword();
            this.typeDescriptor = oldNode.typeDescriptor();
            this.parenthesizedArgList = oldNode.parenthesizedArgList();
        }

        public ExplicitNewExpressionNodeModifier withNewKeyword(Token newKeyword) {
            Objects.requireNonNull(newKeyword, "newKeyword must not be null");
            this.newKeyword = newKeyword;
            return this;
        }

        public ExplicitNewExpressionNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public ExplicitNewExpressionNodeModifier withParenthesizedArgList(ParenthesizedArgList parenthesizedArgList) {
            Objects.requireNonNull(parenthesizedArgList, "parenthesizedArgList must not be null");
            this.parenthesizedArgList = parenthesizedArgList;
            return this;
        }

        public ExplicitNewExpressionNode apply() {
            return this.oldNode.modify(this.newKeyword, this.typeDescriptor, this.parenthesizedArgList);
        }
    }
}

