/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarator;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeAndCommentList;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class FunctionBodyBlockNode
extends FunctionBodyNode {
    public FunctionBodyBlockNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(0);
    }

    public Optional<NamedWorkerDeclarator> namedWorkerDeclarator() {
        return this.optionalChildInBucket(1);
    }

    public NodeList<StatementNode> statements() {
        return new NodeList<StatementNode>((NonTerminalNode)this.childInBucket(2));
    }

    public NodeAndCommentList<Node> statementsWithComments() {
        return new NodeAndCommentList<Node>((NonTerminalNode)this.childInBucket(2), (Token)this.childInBucket(3));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(3);
    }

    public Optional<Token> semicolonToken() {
        return this.optionalChildInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBraceToken", "namedWorkerDeclarator", "statements", "closeBraceToken", "semicolonToken"};
    }

    public FunctionBodyBlockNode modify(Token openBraceToken, NamedWorkerDeclarator namedWorkerDeclarator, NodeList<StatementNode> statements, Token closeBraceToken, Token semicolonToken) {
        if (this.checkForReferenceEquality(openBraceToken, namedWorkerDeclarator, statements.underlyingListNode(), closeBraceToken, semicolonToken)) {
            return this;
        }
        return NodeFactory.createFunctionBodyBlockNode(openBraceToken, namedWorkerDeclarator, statements, closeBraceToken, semicolonToken);
    }

    public FunctionBodyBlockNodeModifier modify() {
        return new FunctionBodyBlockNodeModifier(this);
    }

    public static class FunctionBodyBlockNodeModifier {
        private final FunctionBodyBlockNode oldNode;
        private Token openBraceToken;
        private NamedWorkerDeclarator namedWorkerDeclarator;
        private NodeList<StatementNode> statements;
        private Token closeBraceToken;
        private Token semicolonToken;

        public FunctionBodyBlockNodeModifier(FunctionBodyBlockNode oldNode) {
            this.oldNode = oldNode;
            this.openBraceToken = oldNode.openBraceToken();
            this.namedWorkerDeclarator = oldNode.namedWorkerDeclarator().orElse(null);
            this.statements = oldNode.statements();
            this.closeBraceToken = oldNode.closeBraceToken();
            this.semicolonToken = oldNode.semicolonToken().orElse(null);
        }

        public FunctionBodyBlockNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public FunctionBodyBlockNodeModifier withNamedWorkerDeclarator(NamedWorkerDeclarator namedWorkerDeclarator) {
            this.namedWorkerDeclarator = namedWorkerDeclarator;
            return this;
        }

        public FunctionBodyBlockNodeModifier withStatements(NodeList<StatementNode> statements) {
            Objects.requireNonNull(statements, "statements must not be null");
            this.statements = statements;
            return this;
        }

        public FunctionBodyBlockNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public FunctionBodyBlockNodeModifier withSemicolonToken(Token semicolonToken) {
            this.semicolonToken = semicolonToken;
            return this;
        }

        public FunctionBodyBlockNode apply() {
            return this.oldNode.modify(this.openBraceToken, this.namedWorkerDeclarator, this.statements, this.closeBraceToken, this.semicolonToken);
        }
    }
}

