/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class FunctionDefinitionNode
extends ModuleMemberDeclarationNode {
    public FunctionDefinitionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public NodeList<Token> qualifierList() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(1));
    }

    public Token functionKeyword() {
        return (Token)this.childInBucket(2);
    }

    public IdentifierToken functionName() {
        return (IdentifierToken)this.childInBucket(3);
    }

    public NodeList<Node> relativeResourcePath() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(4));
    }

    public FunctionSignatureNode functionSignature() {
        return (FunctionSignatureNode)this.childInBucket(5);
    }

    public FunctionBodyNode functionBody() {
        return (FunctionBodyNode)this.childInBucket(6);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "qualifierList", "functionKeyword", "functionName", "relativeResourcePath", "functionSignature", "functionBody"};
    }

    public FunctionDefinitionNode modify(SyntaxKind kind, MetadataNode metadata, NodeList<Token> qualifierList, Token functionKeyword, IdentifierToken functionName, NodeList<Node> relativeResourcePath, FunctionSignatureNode functionSignature, FunctionBodyNode functionBody) {
        if (this.checkForReferenceEquality(metadata, qualifierList.underlyingListNode(), functionKeyword, functionName, relativeResourcePath.underlyingListNode(), functionSignature, functionBody)) {
            return this;
        }
        return NodeFactory.createFunctionDefinitionNode(kind, metadata, qualifierList, functionKeyword, functionName, relativeResourcePath, functionSignature, functionBody);
    }

    public FunctionDefinitionNodeModifier modify() {
        return new FunctionDefinitionNodeModifier(this);
    }

    public static class FunctionDefinitionNodeModifier {
        private final FunctionDefinitionNode oldNode;
        private MetadataNode metadata;
        private NodeList<Token> qualifierList;
        private Token functionKeyword;
        private IdentifierToken functionName;
        private NodeList<Node> relativeResourcePath;
        private FunctionSignatureNode functionSignature;
        private FunctionBodyNode functionBody;

        public FunctionDefinitionNodeModifier(FunctionDefinitionNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.qualifierList = oldNode.qualifierList();
            this.functionKeyword = oldNode.functionKeyword();
            this.functionName = oldNode.functionName();
            this.relativeResourcePath = oldNode.relativeResourcePath();
            this.functionSignature = oldNode.functionSignature();
            this.functionBody = oldNode.functionBody();
        }

        public FunctionDefinitionNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public FunctionDefinitionNodeModifier withQualifierList(NodeList<Token> qualifierList) {
            Objects.requireNonNull(qualifierList, "qualifierList must not be null");
            this.qualifierList = qualifierList;
            return this;
        }

        public FunctionDefinitionNodeModifier withFunctionKeyword(Token functionKeyword) {
            Objects.requireNonNull(functionKeyword, "functionKeyword must not be null");
            this.functionKeyword = functionKeyword;
            return this;
        }

        public FunctionDefinitionNodeModifier withFunctionName(IdentifierToken functionName) {
            Objects.requireNonNull(functionName, "functionName must not be null");
            this.functionName = functionName;
            return this;
        }

        public FunctionDefinitionNodeModifier withRelativeResourcePath(NodeList<Node> relativeResourcePath) {
            Objects.requireNonNull(relativeResourcePath, "relativeResourcePath must not be null");
            this.relativeResourcePath = relativeResourcePath;
            return this;
        }

        public FunctionDefinitionNodeModifier withFunctionSignature(FunctionSignatureNode functionSignature) {
            Objects.requireNonNull(functionSignature, "functionSignature must not be null");
            this.functionSignature = functionSignature;
            return this;
        }

        public FunctionDefinitionNodeModifier withFunctionBody(FunctionBodyNode functionBody) {
            Objects.requireNonNull(functionBody, "functionBody must not be null");
            this.functionBody = functionBody;
            return this;
        }

        public FunctionDefinitionNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.metadata, this.qualifierList, this.functionKeyword, this.functionName, this.relativeResourcePath, this.functionSignature, this.functionBody);
        }
    }
}

