/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class LetExpressionNode
extends ExpressionNode {
    public LetExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token letKeyword() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations() {
        return new SeparatedNodeList<LetVariableDeclarationNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token inKeyword() {
        return (Token)this.childInBucket(2);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"letKeyword", "letVarDeclarations", "inKeyword", "expression"};
    }

    public LetExpressionNode modify(Token letKeyword, SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations, Token inKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(letKeyword, letVarDeclarations.underlyingListNode(), inKeyword, expression)) {
            return this;
        }
        return NodeFactory.createLetExpressionNode(letKeyword, letVarDeclarations, inKeyword, expression);
    }

    public LetExpressionNodeModifier modify() {
        return new LetExpressionNodeModifier(this);
    }

    public static class LetExpressionNodeModifier {
        private final LetExpressionNode oldNode;
        private Token letKeyword;
        private SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations;
        private Token inKeyword;
        private ExpressionNode expression;

        public LetExpressionNodeModifier(LetExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.letKeyword = oldNode.letKeyword();
            this.letVarDeclarations = oldNode.letVarDeclarations();
            this.inKeyword = oldNode.inKeyword();
            this.expression = oldNode.expression();
        }

        public LetExpressionNodeModifier withLetKeyword(Token letKeyword) {
            Objects.requireNonNull(letKeyword, "letKeyword must not be null");
            this.letKeyword = letKeyword;
            return this;
        }

        public LetExpressionNodeModifier withLetVarDeclarations(SeparatedNodeList<LetVariableDeclarationNode> letVarDeclarations) {
            Objects.requireNonNull(letVarDeclarations, "letVarDeclarations must not be null");
            this.letVarDeclarations = letVarDeclarations;
            return this;
        }

        public LetExpressionNodeModifier withInKeyword(Token inKeyword) {
            Objects.requireNonNull(inKeyword, "inKeyword must not be null");
            this.inKeyword = inKeyword;
            return this;
        }

        public LetExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public LetExpressionNode apply() {
            return this.oldNode.modify(this.letKeyword, this.letVarDeclarations, this.inKeyword, this.expression);
        }
    }
}

