/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeLineNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class MarkdownCodeBlockNode
extends DocumentationNode {
    public MarkdownCodeBlockNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token startLineHashToken() {
        return (Token)this.childInBucket(0);
    }

    public Token startBacktick() {
        return (Token)this.childInBucket(1);
    }

    public Optional<Token> langAttribute() {
        return this.optionalChildInBucket(2);
    }

    public NodeList<MarkdownCodeLineNode> codeLines() {
        return new NodeList<MarkdownCodeLineNode>((NonTerminalNode)this.childInBucket(3));
    }

    public Token endLineHashToken() {
        return (Token)this.childInBucket(4);
    }

    public Token endBacktick() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"startLineHashToken", "startBacktick", "langAttribute", "codeLines", "endLineHashToken", "endBacktick"};
    }

    public MarkdownCodeBlockNode modify(Token startLineHashToken, Token startBacktick, Token langAttribute, NodeList<MarkdownCodeLineNode> codeLines, Token endLineHashToken, Token endBacktick) {
        if (this.checkForReferenceEquality(startLineHashToken, startBacktick, langAttribute, codeLines.underlyingListNode(), endLineHashToken, endBacktick)) {
            return this;
        }
        return NodeFactory.createMarkdownCodeBlockNode(startLineHashToken, startBacktick, langAttribute, codeLines, endLineHashToken, endBacktick);
    }

    public MarkdownCodeBlockNodeModifier modify() {
        return new MarkdownCodeBlockNodeModifier(this);
    }

    public static class MarkdownCodeBlockNodeModifier {
        private final MarkdownCodeBlockNode oldNode;
        private Token startLineHashToken;
        private Token startBacktick;
        private Token langAttribute;
        private NodeList<MarkdownCodeLineNode> codeLines;
        private Token endLineHashToken;
        private Token endBacktick;

        public MarkdownCodeBlockNodeModifier(MarkdownCodeBlockNode oldNode) {
            this.oldNode = oldNode;
            this.startLineHashToken = oldNode.startLineHashToken();
            this.startBacktick = oldNode.startBacktick();
            this.langAttribute = oldNode.langAttribute().orElse(null);
            this.codeLines = oldNode.codeLines();
            this.endLineHashToken = oldNode.endLineHashToken();
            this.endBacktick = oldNode.endBacktick();
        }

        public MarkdownCodeBlockNodeModifier withStartLineHashToken(Token startLineHashToken) {
            Objects.requireNonNull(startLineHashToken, "startLineHashToken must not be null");
            this.startLineHashToken = startLineHashToken;
            return this;
        }

        public MarkdownCodeBlockNodeModifier withStartBacktick(Token startBacktick) {
            Objects.requireNonNull(startBacktick, "startBacktick must not be null");
            this.startBacktick = startBacktick;
            return this;
        }

        public MarkdownCodeBlockNodeModifier withLangAttribute(Token langAttribute) {
            this.langAttribute = langAttribute;
            return this;
        }

        public MarkdownCodeBlockNodeModifier withCodeLines(NodeList<MarkdownCodeLineNode> codeLines) {
            Objects.requireNonNull(codeLines, "codeLines must not be null");
            this.codeLines = codeLines;
            return this;
        }

        public MarkdownCodeBlockNodeModifier withEndLineHashToken(Token endLineHashToken) {
            Objects.requireNonNull(endLineHashToken, "endLineHashToken must not be null");
            this.endLineHashToken = endLineHashToken;
            return this;
        }

        public MarkdownCodeBlockNodeModifier withEndBacktick(Token endBacktick) {
            Objects.requireNonNull(endBacktick, "endBacktick must not be null");
            this.endBacktick = endBacktick;
            return this;
        }

        public MarkdownCodeBlockNode apply() {
            return this.oldNode.modify(this.startLineHashToken, this.startBacktick, this.langAttribute, this.codeLines, this.endLineHashToken, this.endBacktick);
        }
    }
}

